/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubLoginPanel {
    private JPanel myPane;
    private JTextField myHostTextField;
    private JTextField myLoginTextField;
    private JPasswordField myPasswordField;
    private JTextPane mySignupTextField;
    private JCheckBox mySavePasswordCheckBox;
    private ComboBox myAuthTypeComboBox;
    private JLabel myPasswordLabel;
    private JLabel myLoginLabel;
    private static final String AUTH_PASSWORD = "Password";
    private static final String AUTH_TOKEN = "Token";

    public GithubLoginPanel(final GithubLoginDialog dialog) {
        this.$$$setupUI$$$();
        DocumentAdapter listener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                dialog.clearErrors();
            }
        };
        this.myLoginTextField.getDocument().addDocumentListener((DocumentListener)listener);
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)listener);
        this.mySignupTextField.setText("<html>Do not have an account at github.com? <a href=\"https://github.com\">Sign up</a>.</html>");
        this.mySignupTextField.setMargin(new Insets(5, 0, 0, 0));
        this.mySignupTextField.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
        this.mySignupTextField.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.mySignupTextField.setCursor(new Cursor(12));
        this.myAuthTypeComboBox.addItem((Object)AUTH_PASSWORD);
        this.myAuthTypeComboBox.addItem((Object)AUTH_TOKEN);
        this.myAuthTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String item = e.getItem().toString();
                    if (GithubLoginPanel.AUTH_PASSWORD.equals(item)) {
                        GithubLoginPanel.this.myPasswordLabel.setText("Password:");
                        GithubLoginPanel.this.mySavePasswordCheckBox.setText("Save password");
                        GithubLoginPanel.this.myLoginLabel.setVisible(true);
                        GithubLoginPanel.this.myLoginTextField.setVisible(true);
                    } else if (GithubLoginPanel.AUTH_TOKEN.equals(item)) {
                        GithubLoginPanel.this.myPasswordLabel.setText("Token:");
                        GithubLoginPanel.this.mySavePasswordCheckBox.setText("Save token");
                        GithubLoginPanel.this.myLoginLabel.setVisible(false);
                        GithubLoginPanel.this.myLoginTextField.setVisible(false);
                    }
                    if (dialog.isShowing()) {
                        dialog.pack();
                    }
                }
            }
        });
        ArrayList<JComponent> order = new ArrayList<JComponent>();
        order.add(this.myHostTextField);
        order.add((JComponent)this.myAuthTypeComboBox);
        order.add(this.myLoginTextField);
        order.add(this.myPasswordField);
        order.add(this.mySavePasswordCheckBox);
        this.myPane.setFocusTraversalPolicyProvider(true);
        this.myPane.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyFocusTraversalPolicy(order)));
    }

    public JComponent getPanel() {
        return this.myPane;
    }

    public void setHost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "setHost"));
        }
        this.myHostTextField.setText(host);
    }

    public void setLogin(@Nullable String login) {
        this.myLoginTextField.setText(login);
    }

    public void setAuthType(@NotNull GithubAuthData.AuthType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "setAuthType"));
        }
        switch (type) {
            case BASIC: {
                this.myAuthTypeComboBox.setSelectedItem((Object)AUTH_PASSWORD);
                break;
            }
            case TOKEN: {
                this.myAuthTypeComboBox.setSelectedItem((Object)AUTH_TOKEN);
                break;
            }
            case ANONYMOUS: {
                this.myAuthTypeComboBox.setSelectedItem((Object)AUTH_PASSWORD);
            }
        }
    }

    public void lockAuthType(@NotNull GithubAuthData.AuthType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "lockAuthType"));
        }
        this.setAuthType(type);
        this.myAuthTypeComboBox.setEnabled(false);
    }

    public void lockHost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "lockHost"));
        }
        this.setHost(host);
        this.myHostTextField.setEnabled(false);
    }

    public void setSavePasswordSelected(boolean savePassword) {
        this.mySavePasswordCheckBox.setSelected(savePassword);
    }

    public void setSavePasswordVisibleEnabled(boolean visible) {
        this.mySavePasswordCheckBox.setVisible(visible);
        this.mySavePasswordCheckBox.setEnabled(visible);
    }

    @NotNull
    public String getHost() {
        String string = this.myHostTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "getHost"));
        }
        return string;
    }

    @NotNull
    public String getLogin() {
        String string = this.myLoginTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "getLogin"));
        }
        return string;
    }

    @NotNull
    private String getPassword() {
        String string = String.valueOf(this.myPasswordField.getPassword());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "getPassword"));
        }
        return string;
    }

    public boolean isSavePasswordSelected() {
        return this.mySavePasswordCheckBox.isSelected();
    }

    public JComponent getPreferableFocusComponent() {
        return this.myLoginTextField.isVisible() ? this.myLoginTextField : this.myPasswordField;
    }

    @NotNull
    public GithubAuthData getAuthData() {
        Object selected = this.myAuthTypeComboBox.getSelectedItem();
        if (AUTH_PASSWORD.equals(selected)) {
            GithubAuthData githubAuthData = GithubAuthData.createBasicAuth(this.getHost(), this.getLogin(), this.getPassword());
            if (githubAuthData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "getAuthData"));
            }
            return githubAuthData;
        }
        if (AUTH_TOKEN.equals(selected)) {
            GithubAuthData githubAuthData = GithubAuthData.createTokenAuth(this.getHost(), this.getPassword());
            if (githubAuthData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "getAuthData"));
            }
            return githubAuthData;
        }
        GithubUtil.LOG.error("GithubLoginPanel illegal selection: anonymous AuthData created", new String[]{selected.toString()});
        GithubAuthData githubAuthData = GithubAuthData.createAnonymous(this.getHost());
        if (githubAuthData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginPanel", "getAuthData"));
        }
        return githubAuthData;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JCheckBox jCheckBox;
        JPasswordField jPasswordField;
        JTextField jTextField2;
        JTextPane jTextPane;
        JPanel jPanel;
        this.myPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setFocusable(false);
        this.mySignupTextField = jTextPane = new JTextPane();
        ((Component)jTextPane).setFont(UIManager.getFont("Label.font"));
        ((Component)jTextPane).setEnabled(true);
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        jTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel.add((Component)jTextPane, new GridConstraints(4, 0, 1, 3, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Host:");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(3, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(300, -1), null));
        this.mySavePasswordCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Save password");
        jCheckBox.setSelected(true);
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Auth type:");
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordLabel = jLabel2 = new JLabel();
        jLabel2.setText("Password:");
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLoginTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myLoginLabel = jLabel = new JLabel();
        jLabel.setText("Login:");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAuthTypeComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPane;
    }

    private static class MyFocusTraversalPolicy
    extends ComponentsListFocusTraversalPolicy {
        @NotNull
        private List<Component> myOrder;

        private MyFocusTraversalPolicy(@NotNull List<Component> order) {
            if (order == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubLoginPanel$MyFocusTraversalPolicy", "<init>"));
            }
            this.myOrder = order;
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            List list = ContainerUtil.filter(this.myOrder, (Condition)new Condition<Component>(){

                public boolean value(Component component) {
                    return component.isVisible() && component.isEnabled();
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubLoginPanel$MyFocusTraversalPolicy", "getOrderedComponents"));
            }
            return list;
        }
    }
}

