/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubCreatePullRequestPanel {
    private JTextField myTitleTextField;
    private JTextArea myDescriptionTextArea;
    private ComboBox myBranchComboBox;
    private SortedComboBoxModel<String> myBranchModel;
    private JPanel myPanel;
    private JButton myShowDiffButton;
    private JButton mySelectForkButton;
    private JLabel myForkLabel;
    private AsyncProcessIcon myBusyIcon;
    private boolean myTitleDescriptionUserModified = false;

    public GithubCreatePullRequestPanel() {
        this.$$$setupUI$$$();
        this.myDescriptionTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.myBranchModel = new SortedComboBoxModel((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return StringUtil.naturalCompare((String)o1, (String)o2);
            }
        });
        this.myBranchComboBox.setModel(this.myBranchModel);
        DocumentAdapter userModifiedDocumentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GithubCreatePullRequestPanel.this.myTitleDescriptionUserModified = true;
            }
        };
        this.myTitleTextField.getDocument().addDocumentListener((DocumentListener)userModifiedDocumentListener);
        this.myDescriptionTextArea.getDocument().addDocumentListener((DocumentListener)userModifiedDocumentListener);
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitleTextField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getTitle"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescriptionTextArea.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getBranch() {
        String string = this.myBranchComboBox.getSelectedItem().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getBranch"));
        }
        return string;
    }

    public void setDiffEnabled(boolean enabled) {
        this.myShowDiffButton.setEnabled(enabled);
    }

    public void setSelectedBranch(@Nullable String branch) {
        if (StringUtil.isEmptyOrSpaces((String)branch)) {
            return;
        }
        this.myBranchComboBox.setSelectedItem((Object)branch);
    }

    public void setBranches(@NotNull Collection<String> branches) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "setBranches"));
        }
        this.myBranchModel.clear();
        this.myBranchModel.addAll(branches);
        if (branches.size() > 0) {
            this.myBranchComboBox.setSelectedIndex(0);
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @NotNull
    public JComponent getPreferredComponent() {
        JTextField jTextField = this.myTitleTextField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getPreferredComponent"));
        }
        return jTextField;
    }

    @NotNull
    public JComponent getBranchEditor() {
        ComboBox comboBox = this.myBranchComboBox;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getBranchEditor"));
        }
        return comboBox;
    }

    @NotNull
    public JComponent getTitleTextField() {
        JTextField jTextField = this.myTitleTextField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getTitleTextField"));
        }
        return jTextField;
    }

    @NotNull
    public JButton getShowDiffButton() {
        JButton jButton = this.myShowDiffButton;
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getShowDiffButton"));
        }
        return jButton;
    }

    @NotNull
    public JButton getSelectForkButton() {
        JButton jButton = this.mySelectForkButton;
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getSelectForkButton"));
        }
        return jButton;
    }

    @NotNull
    public ComboBox getBranchComboBox() {
        ComboBox comboBox = this.myBranchComboBox;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getBranchComboBox"));
        }
        return comboBox;
    }

    public void setTitle(@Nullable String title) {
        this.myTitleTextField.setText(title);
        this.myTitleDescriptionUserModified = false;
    }

    public void setDescription(@Nullable String title) {
        this.myDescriptionTextArea.setText(title);
        this.myTitleDescriptionUserModified = false;
    }

    public boolean isTitleDescriptionEmptyOrNotModified() {
        return !this.myTitleDescriptionUserModified || StringUtil.isEmptyOrSpaces((String)this.myTitleTextField.getText()) && StringUtil.isEmptyOrSpaces((String)this.myDescriptionTextArea.getText());
    }

    public void setForkName(@NotNull String forkName) {
        if (forkName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "setForkName"));
        }
        this.myForkLabel.setText(forkName);
    }

    public void setBusy(boolean enabled) {
        if (enabled) {
            this.myBusyIcon.resume();
        } else {
            this.myBusyIcon.suspend();
        }
    }

    private void createUIComponents() {
        this.myBusyIcon = new AsyncProcessIcon("Loading diff...");
        this.myBusyIcon.suspend();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JLabel jLabel;
        JButton jButton;
        JButton jButton2;
        JTextArea jTextArea;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Base branch:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Title:");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Description:");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTitleTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(4, 0, 1, 4, 0, 3, 7, 7, new Dimension(150, 50), null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myDescriptionTextArea = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
        this.myShowDiffButton = jButton2 = new JButton();
        jButton2.setText("Show Diff");
        jPanel.add((Component)jButton2, new GridConstraints(1, 3, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Base fork:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySelectForkButton = jButton = new JButton();
        jButton.setText("Select Base Fork");
        jPanel.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myForkLabel = jLabel = new JLabel();
        jLabel.setText("repo");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myBusyIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBranchComboBox = comboBox = new ComboBox();
        comboBox.setToolTipText("");
        comboBox.setEditable(false);
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

