/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.ui.GithubCreateGistPanel;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubCreateGistDialog
extends DialogWrapper {
    private final GithubCreateGistPanel myGithubCreateGistPanel;

    public GithubCreateGistDialog(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile[] files, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/ui/GithubCreateGistDialog", "<init>"));
        }
        super(project, true);
        this.myGithubCreateGistPanel = new GithubCreateGistPanel();
        GithubSettings settings = GithubSettings.getInstance();
        this.myGithubCreateGistPanel.setAnonymous(settings.isAnonymousGist());
        this.myGithubCreateGistPanel.setPrivate(settings.isPrivateGist());
        this.myGithubCreateGistPanel.setOpenInBrowser(settings.isOpenInBrowserGist());
        if (editor != null) {
            if (file != null) {
                this.myGithubCreateGistPanel.showFileNameField(file.getName());
            } else {
                this.myGithubCreateGistPanel.showFileNameField("");
            }
        } else if (files != null) {
            if (files.length == 1 && !files[0].isDirectory()) {
                this.myGithubCreateGistPanel.showFileNameField(files[0].getName());
            }
        } else if (file != null && !file.isDirectory()) {
            this.myGithubCreateGistPanel.showFileNameField(file.getName());
        }
        this.setTitle("Create Gist");
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myGithubCreateGistPanel.getPanel();
    }

    protected String getHelpId() {
        return "github.create.gist.dialog";
    }

    protected String getDimensionServiceKey() {
        return "Github.CreateGistDialog";
    }

    protected void doOKAction() {
        GithubSettings settings = GithubSettings.getInstance();
        settings.setAnonymousGist(this.myGithubCreateGistPanel.isAnonymous());
        settings.setOpenInBrowserGist(this.myGithubCreateGistPanel.isOpenInBrowser());
        settings.setPrivateGist(this.myGithubCreateGistPanel.isPrivate());
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGithubCreateGistPanel.getDescriptionTextArea();
    }

    public boolean isPrivate() {
        return this.myGithubCreateGistPanel.isPrivate();
    }

    public boolean isAnonymous() {
        return this.myGithubCreateGistPanel.isAnonymous();
    }

    @NotNull
    public String getDescription() {
        String string = this.myGithubCreateGistPanel.getDescriptionTextArea().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreateGistDialog", "getDescription"));
        }
        return string;
    }

    @Nullable
    public String getFileName() {
        return this.myGithubCreateGistPanel.getFileNameField().getText();
    }

    public boolean isOpenInBrowser() {
        return this.myGithubCreateGistPanel.isOpenInBrowser();
    }
}

