/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import icons.TasksIcons;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubIssue;
import org.jetbrains.plugins.github.api.GithubIssueComment;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.tasks.GithubComment;
import org.jetbrains.plugins.github.tasks.GithubRepositoryType;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubUtil;

@Tag(value="GitHub")
public class GithubRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = GithubUtil.LOG;
    private Pattern myPattern = Pattern.compile("($^)");
    @NotNull
    private String myRepoAuthor = "";
    @NotNull
    private String myRepoName = "";
    @NotNull
    private String myUser = "";
    @NotNull
    private String myToken = "";

    public GithubRepository() {
    }

    public GithubRepository(GithubRepository other) {
        super((BaseRepositoryImpl)other);
        this.setRepoName(other.myRepoName);
        this.setRepoAuthor(other.myRepoAuthor);
        this.setToken(other.myToken);
    }

    public GithubRepository(GithubRepositoryType type) {
        super((TaskRepositoryType)type);
        this.setUrl("github.com");
    }

    public void testConnection() throws Exception {
        this.getIssues("", 10, 0L);
    }

    public boolean isConfigured() {
        return super.isConfigured() && !StringUtil.isEmptyOrSpaces((String)this.getRepoAuthor()) && !StringUtil.isEmptyOrSpaces((String)this.getRepoName()) && !StringUtil.isEmptyOrSpaces((String)this.getToken());
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + (!StringUtil.isEmpty((String)this.getRepoAuthor()) ? "/" + this.getRepoAuthor() : "") + (!StringUtil.isEmpty((String)this.getRepoName()) ? "/" + this.getRepoName() : "");
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        try {
            return this.getIssues(query, max);
        }
        catch (GithubRateLimitExceededException e) {
            return new Task[0];
        }
        catch (GithubAuthenticationException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (GithubStatusCodeException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (GithubJsonException e) {
            throw new Exception("Bad response format", e);
        }
    }

    @NotNull
    private Task[] getIssues(@Nullable String query, int max) throws Exception {
        List<GithubIssue> issues;
        if (StringUtil.isEmptyOrSpaces((String)query)) {
            if (StringUtil.isEmptyOrSpaces((String)this.myUser)) {
                this.myUser = GithubApiUtil.getCurrentUser(this.getAuthData()).getLogin();
            }
            issues = GithubApiUtil.getIssuesAssigned(this.getAuthData(), this.getRepoAuthor(), this.getRepoName(), this.myUser, max);
        } else {
            issues = GithubApiUtil.getIssuesQueried(this.getAuthData(), this.getRepoAuthor(), this.getRepoName(), query);
        }
        Task[] taskArray = (Task[])ContainerUtil.map2Array(issues, Task.class, (Function)new Function<GithubIssue, Task>(){

            public Task fun(GithubIssue issue) {
                return GithubRepository.this.createTask(issue);
            }
        });
        if (taskArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository", "getIssues"));
        }
        return taskArray;
    }

    @NotNull
    private Task createTask(final GithubIssue issue) {
        Task task = new Task(){
            @NotNull
            String myRepoName;
            {
                this.myRepoName = GithubRepository.this.getRepoName();
            }

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                return issue.getHtmlUrl();
            }

            @NotNull
            public String getId() {
                String string = this.myRepoName + "-" + issue.getNumber();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository$2", "getId"));
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = issue.getTitle();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository$2", "getSummary"));
                }
                return string;
            }

            public String getDescription() {
                return issue.getBody();
            }

            @NotNull
            public Comment[] getComments() {
                Comment[] commentArray;
                try {
                    commentArray = GithubRepository.this.fetchComments(issue.getNumber());
                }
                catch (Exception e) {
                    LOG.warn("Error fetching comments for " + issue.getNumber(), (Throwable)e);
                    if (Comment.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository$2", "getComments"));
                    }
                    return Comment.EMPTY_ARRAY;
                }
                if (commentArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository$2", "getComments"));
                }
                return commentArray;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = TasksIcons.Github;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository$2", "getIcon"));
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = TaskType.BUG;
                if (taskType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository$2", "getType"));
                }
                return taskType;
            }

            public Date getUpdated() {
                return issue.getUpdatedAt();
            }

            public Date getCreated() {
                return issue.getCreatedAt();
            }

            public boolean isClosed() {
                return !"open".equals(issue.getState());
            }

            public TaskRepository getRepository() {
                return GithubRepository.this;
            }

            public String getPresentableName() {
                return this.getId() + ": " + this.getSummary();
            }
        };
        if (task == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository", "createTask"));
        }
        return task;
    }

    private Comment[] fetchComments(long id) throws Exception {
        List<GithubIssueComment> result = GithubApiUtil.getIssueComments(this.getAuthData(), this.getRepoAuthor(), this.getRepoName(), id);
        return (Comment[])ContainerUtil.map2Array(result, Comment.class, (Function)new Function<GithubIssueComment, Comment>(){

            public Comment fun(GithubIssueComment comment) {
                return new GithubComment(comment.getCreatedAt(), comment.getUser().getLogin(), comment.getBodyHtml(), comment.getUser().getGravatarId(), comment.getUser().getHtmlUrl());
            }
        });
    }

    @Nullable
    public String extractId(String taskName) {
        Matcher matcher = this.myPattern.matcher(taskName);
        return matcher.find() ? matcher.group(1) : null;
    }

    @Nullable
    public Task findTask(String id) throws Exception {
        return this.createTask(GithubApiUtil.getIssue(this.getAuthData(), this.getRepoAuthor(), this.getRepoName(), id));
    }

    public BaseRepository clone() {
        return new GithubRepository(this);
    }

    @NotNull
    public String getRepoName() {
        String string = this.myRepoName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository", "getRepoName"));
        }
        return string;
    }

    public void setRepoName(@NotNull String repoName) {
        if (repoName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/tasks/GithubRepository", "setRepoName"));
        }
        this.myRepoName = repoName;
        this.myPattern = Pattern.compile("(" + StringUtil.escapeToRegexp((String)repoName) + "\\-\\d+):\\s+");
    }

    @NotNull
    public String getRepoAuthor() {
        String string = this.myRepoAuthor;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository", "getRepoAuthor"));
        }
        return string;
    }

    public void setRepoAuthor(@NotNull String repoAuthor) {
        if (repoAuthor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/tasks/GithubRepository", "setRepoAuthor"));
        }
        this.myRepoAuthor = repoAuthor;
    }

    @NotNull
    public String getUser() {
        String string = this.myUser;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository", "getUser"));
        }
        return string;
    }

    public void setUser(@NotNull String user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/tasks/GithubRepository", "setUser"));
        }
        this.myUser = user;
    }

    @Transient
    @NotNull
    public String getToken() {
        String string = this.myToken;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/tasks/GithubRepository", "getToken"));
        }
        return string;
    }

    public void setToken(@NotNull String token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/tasks/GithubRepository", "setToken"));
        }
        this.myToken = token;
        this.setUser("");
    }

    @Tag(value="token")
    public String getEncodedToken() {
        return PasswordUtil.encodePassword((String)this.getToken());
    }

    public void setEncodedToken(String password) {
        try {
            this.setToken(PasswordUtil.decodePassword((String)password));
        }
        catch (NumberFormatException e) {
            LOG.warn("Can't decode token", (Throwable)e);
        }
    }

    private GithubAuthData getAuthData() {
        return GithubAuthData.createTokenAuth(this.getUrl(), this.getToken(), this.isUseProxy());
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof GithubRepository)) {
            return false;
        }
        GithubRepository that = (GithubRepository)((Object)o);
        if (!Comparing.equal((String)this.getRepoAuthor(), (String)that.getRepoAuthor())) {
            return false;
        }
        if (!Comparing.equal((String)this.getRepoName(), (String)that.getRepoName())) {
            return false;
        }
        return Comparing.equal((String)this.getToken(), (String)that.getToken());
    }

    protected int getFeatures() {
        return super.getFeatures() | 1;
    }
}

