/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AuthData;
import git4idea.jgit.GitHttpAuthDataProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

public class GithubHttpAuthDataProvider
implements GitHttpAuthDataProvider {
    @Nullable
    public AuthData getAuthData(@NotNull String url) {
        String host2;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider", "getAuthData"));
        }
        if (!GithubUrlUtil.isGithubUrl(url)) {
            return null;
        }
        GithubSettings settings = GithubSettings.getInstance();
        if (!settings.isValidGitAuth()) {
            return null;
        }
        String host1 = GithubUrlUtil.getHostFromUrl(settings.getHost());
        if (!host1.equalsIgnoreCase(host2 = GithubUrlUtil.getHostFromUrl(url))) {
            return null;
        }
        GithubAuthData auth = settings.getAuthData();
        switch (auth.getAuthType()) {
            case BASIC: {
                GithubAuthData.BasicAuth basicAuth = auth.getBasicAuth();
                assert (basicAuth != null);
                if (StringUtil.isEmptyOrSpaces((String)basicAuth.getLogin()) || StringUtil.isEmptyOrSpaces((String)basicAuth.getPassword())) {
                    return null;
                }
                return new AuthData(basicAuth.getLogin(), basicAuth.getPassword());
            }
            case TOKEN: {
                GithubAuthData.TokenAuth tokenAuth = auth.getTokenAuth();
                assert (tokenAuth != null);
                if (StringUtil.isEmptyOrSpaces((String)tokenAuth.getToken())) {
                    return null;
                }
                return new AuthData(tokenAuth.getToken(), "x-oauth-basic");
            }
        }
        return null;
    }

    public void forgetPassword(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider", "forgetPassword"));
        }
    }
}

