/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubRepo {
    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;
    private final boolean myIsPrivate;
    private final boolean myIsFork;
    @NotNull
    private final String myHtmlUrl;
    @NotNull
    private final String myCloneUrl;
    @Nullable
    private final String myDefaultBranch;
    @NotNull
    private final GithubUser myOwner;

    public GithubRepo(@NotNull String name, @Nullable String description, boolean isPrivate, boolean isFork, @NotNull String htmlUrl, @NotNull String cloneUrl, @Nullable String defaultBranch, @NotNull GithubUser owner) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubRepo", "<init>"));
        }
        if (htmlUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/api/GithubRepo", "<init>"));
        }
        if (cloneUrl == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/github/api/GithubRepo", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "org/jetbrains/plugins/github/api/GithubRepo", "<init>"));
        }
        this.myName = name;
        this.myDescription = StringUtil.notNullize((String)description);
        this.myIsPrivate = isPrivate;
        this.myIsFork = isFork;
        this.myHtmlUrl = htmlUrl;
        this.myCloneUrl = cloneUrl;
        this.myDefaultBranch = defaultBranch;
        this.myOwner = owner;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepo", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFullName() {
        String string = this.getUserName() + "/" + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepo", "getFullName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepo", "getDescription"));
        }
        return string;
    }

    public boolean isPrivate() {
        return this.myIsPrivate;
    }

    public boolean isFork() {
        return this.myIsFork;
    }

    @NotNull
    public String getHtmlUrl() {
        String string = this.myHtmlUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepo", "getHtmlUrl"));
        }
        return string;
    }

    @NotNull
    public String getCloneUrl() {
        String string = this.myCloneUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepo", "getCloneUrl"));
        }
        return string;
    }

    @Nullable
    public String getDefaultBranch() {
        return this.myDefaultBranch;
    }

    @NotNull
    public GithubUser getOwner() {
        GithubUser githubUser = this.myOwner;
        if (githubUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepo", "getOwner"));
        }
        return githubUser;
    }

    @NotNull
    public String getUserName() {
        String string = this.getOwner().getLogin();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepo", "getUserName"));
        }
        return string;
    }

    @NotNull
    public GithubFullPath getFullPath() {
        GithubFullPath githubFullPath = new GithubFullPath(this.getUserName(), this.getName());
        if (githubFullPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepo", "getFullPath"));
        }
        return githubFullPath;
    }
}

