/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubAuthorization;
import org.jetbrains.plugins.github.api.GithubAuthorizationCreateRequest;
import org.jetbrains.plugins.github.api.GithubAuthorizationRaw;
import org.jetbrains.plugins.github.api.GithubAuthorizationUpdateRequest;
import org.jetbrains.plugins.github.api.GithubBranch;
import org.jetbrains.plugins.github.api.GithubBranchRaw;
import org.jetbrains.plugins.github.api.GithubCommit;
import org.jetbrains.plugins.github.api.GithubCommitComment;
import org.jetbrains.plugins.github.api.GithubCommitCommentRaw;
import org.jetbrains.plugins.github.api.GithubCommitDetailed;
import org.jetbrains.plugins.github.api.GithubCommitRaw;
import org.jetbrains.plugins.github.api.GithubErrorMessageRaw;
import org.jetbrains.plugins.github.api.GithubFile;
import org.jetbrains.plugins.github.api.GithubFileRaw;
import org.jetbrains.plugins.github.api.GithubGist;
import org.jetbrains.plugins.github.api.GithubGistRaw;
import org.jetbrains.plugins.github.api.GithubGistRequest;
import org.jetbrains.plugins.github.api.GithubIssue;
import org.jetbrains.plugins.github.api.GithubIssueComment;
import org.jetbrains.plugins.github.api.GithubIssueCommentRaw;
import org.jetbrains.plugins.github.api.GithubIssueRaw;
import org.jetbrains.plugins.github.api.GithubIssuesSearchResult;
import org.jetbrains.plugins.github.api.GithubIssuesSearchResultRaw;
import org.jetbrains.plugins.github.api.GithubOrg;
import org.jetbrains.plugins.github.api.GithubOrgRaw;
import org.jetbrains.plugins.github.api.GithubPullRequest;
import org.jetbrains.plugins.github.api.GithubPullRequestRaw;
import org.jetbrains.plugins.github.api.GithubPullRequestRequest;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.api.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.GithubRepoOrg;
import org.jetbrains.plugins.github.api.GithubRepoRaw;
import org.jetbrains.plugins.github.api.GithubRepoRequest;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.api.GithubUserDetailed;
import org.jetbrains.plugins.github.api.GithubUserRaw;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;
import sun.security.validator.ValidatorException;

public class GithubApiUtil {
    public static final String DEFAULT_GITHUB_HOST = "github.com";
    private static final String PER_PAGE = "per_page=100";
    private static final Logger LOG = GithubUtil.LOG;
    private static final Header ACCEPT_V3_JSON_HTML_MARKUP = new Header("Accept", "application/vnd.github.v3.html+json");
    private static final Header ACCEPT_V3_JSON = new Header("Accept", "application/vnd.github.v3+json");
    @NotNull
    private static final Gson gson = GithubApiUtil.initGson();

    private static Gson initGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder.create();
    }

    @Nullable
    private static JsonElement postRequest(@NotNull GithubAuthData auth, @NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "postRequest"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "postRequest"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "postRequest"));
        }
        return GithubApiUtil.request(auth, path, requestBody, Arrays.asList(headers), HttpVerb.POST).getJsonElement();
    }

    @Nullable
    private static JsonElement patchRequest(@NotNull GithubAuthData auth, @NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "patchRequest"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "patchRequest"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "patchRequest"));
        }
        return GithubApiUtil.request(auth, path, requestBody, Arrays.asList(headers), HttpVerb.PATCH).getJsonElement();
    }

    @Nullable
    private static JsonElement deleteRequest(@NotNull GithubAuthData auth, @NotNull String path, Header ... headers) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteRequest"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteRequest"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteRequest"));
        }
        return GithubApiUtil.request(auth, path, null, Arrays.asList(headers), HttpVerb.DELETE).getJsonElement();
    }

    @Nullable
    private static JsonElement getRequest(@NotNull GithubAuthData auth, @NotNull String path, Header ... headers) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRequest"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRequest"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRequest"));
        }
        return GithubApiUtil.request(auth, path, null, Arrays.asList(headers), HttpVerb.GET).getJsonElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static ResponsePage request(@NotNull GithubAuthData auth, @NotNull String path, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        int end;
        String value;
        int begin;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "request"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "request"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "request"));
        }
        if (verb == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/api/GithubApiUtil", "request"));
        }
        if (EventQueue.isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn("Network operation in EDT");
        }
        HttpMethod method = null;
        String uri = GithubUrlUtil.getApiUrl(auth.getHost()) + path;
        method = GithubApiUtil.doREST(auth, uri, requestBody, headers, verb);
        GithubApiUtil.checkStatusCode(method);
        InputStream resp = method.getResponseBodyAsStream();
        if (resp == null) {
            ResponsePage responsePage = new ResponsePage();
            ResponsePage responsePage2 = responsePage;
            if (responsePage2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "request"));
            }
            return responsePage2;
        }
        JsonElement ret = GithubApiUtil.parseResponse(resp);
        if (ret.isJsonNull()) {
            ResponsePage responsePage = new ResponsePage();
            ResponsePage responsePage3 = responsePage;
            if (responsePage3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "request"));
            }
            return responsePage3;
        }
        Header header = method.getResponseHeader("Link");
        if (header != null && (begin = (value = header.getValue()).lastIndexOf(60, end = value.indexOf(">; rel=\"next\""))) >= 0 && end >= 0) {
            String newPath = GithubUrlUtil.removeProtocolPrefix(value.substring(begin + 1, end));
            int index = newPath.indexOf(47);
            ResponsePage responsePage = new ResponsePage(ret, newPath.substring(index));
            ResponsePage responsePage4 = responsePage;
            if (responsePage4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "request"));
            }
            return responsePage4;
        }
        ResponsePage responsePage = new ResponsePage(ret);
        ResponsePage responsePage5 = responsePage;
        if (responsePage5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "request"));
        }
        return responsePage5;
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @NotNull
    private static HttpMethod doREST(@NotNull GithubAuthData auth, @NotNull String uri, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        GithubAuthData.BasicAuth basicAuth;
        GithubAuthData.TokenAuth tokenAuth;
        PostMethod method;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "doREST"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "doREST"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "doREST"));
        }
        if (verb == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/api/GithubApiUtil", "doREST"));
        }
        HttpClient client = GithubApiUtil.getHttpClient(auth.getBasicAuth(), auth.isUseProxy());
        switch (verb) {
            case POST: {
                method = new PostMethod(uri);
                if (requestBody == null) break;
                method.setRequestEntity((RequestEntity)new StringRequestEntity(requestBody, "application/json", "UTF-8"));
                break;
            }
            case PATCH: {
                method = new PostMethod(uri){

                    public String getName() {
                        return "PATCH";
                    }
                };
                if (requestBody == null) break;
                method.setRequestEntity((RequestEntity)new StringRequestEntity(requestBody, "application/json", "UTF-8"));
                break;
            }
            case GET: {
                method = new GetMethod(uri);
                break;
            }
            case DELETE: {
                method = new DeleteMethod(uri);
                break;
            }
            case HEAD: {
                method = new HeadMethod(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Wrong HttpVerb: unknown method: " + verb.toString());
            }
        }
        if ((tokenAuth = auth.getTokenAuth()) != null) {
            method.addRequestHeader("Authorization", "token " + tokenAuth.getToken());
        }
        if ((basicAuth = auth.getBasicAuth()) != null && basicAuth.getCode() != null) {
            method.addRequestHeader("X-GitHub-OTP", basicAuth.getCode());
        }
        for (Header header : headers) {
            method.addRequestHeader(header);
        }
        try {
            client.executeMethod((HttpMethod)method);
        }
        catch (SSLHandshakeException e) {
            if (e.getCause() instanceof ValidatorException) {
                LOG.info("Host SSL certificate is not trusted", (Throwable)e);
                throw new GithubOperationCanceledException("Host SSL certificate is not trusted", e);
            }
            throw e;
        }
        PostMethod postMethod = method;
        if (postMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "doREST"));
        }
        return postMethod;
    }

    @NotNull
    private static HttpClient getHttpClient(@Nullable GithubAuthData.BasicAuth basicAuth, boolean useProxy) {
        int timeout = GithubSettings.getInstance().getConnectionTimeout();
        HttpClient client = new HttpClient();
        HttpConnectionManagerParams params = client.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(timeout);
        params.setSoTimeout(timeout);
        client.getParams().setContentCharset("UTF-8");
        HttpConfigurable proxySettings = HttpConfigurable.getInstance();
        if (useProxy && proxySettings.USE_HTTP_PROXY && !StringUtil.isEmptyOrSpaces((String)proxySettings.PROXY_HOST)) {
            client.getHostConfiguration().setProxy(proxySettings.PROXY_HOST, proxySettings.PROXY_PORT);
            if (proxySettings.PROXY_AUTHENTICATION) {
                client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxySettings.PROXY_LOGIN, proxySettings.getPlainProxyPassword()));
            }
        }
        if (basicAuth != null) {
            client.getParams().setCredentialCharset("UTF-8");
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuth.getLogin(), basicAuth.getPassword()));
        }
        HttpClient httpClient = client;
        if (httpClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getHttpClient"));
        }
        return httpClient;
    }

    private static void checkStatusCode(@NotNull HttpMethod method) throws IOException {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "checkStatusCode"));
        }
        int code = method.getStatusCode();
        switch (code) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                return;
            }
            case 400: 
            case 401: 
            case 402: 
            case 403: {
                String message = GithubApiUtil.getErrorMessage(method);
                Header headerOTP = method.getResponseHeader("X-GitHub-OTP");
                if (headerOTP != null && headerOTP.getValue().startsWith("required")) {
                    throw new GithubTwoFactorAuthenticationException(message);
                }
                if (message.contains("API rate limit exceeded")) {
                    throw new GithubRateLimitExceededException(message);
                }
                throw new GithubAuthenticationException("Request response: " + message);
            }
        }
        throw new GithubStatusCodeException(code + ": " + GithubApiUtil.getErrorMessage(method), code);
    }

    @NotNull
    private static String getErrorMessage(@NotNull HttpMethod method) {
        block5: {
            String string;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getErrorMessage"));
            }
            try {
                InputStream resp = method.getResponseBodyAsStream();
                if (resp == null) break block5;
                GithubErrorMessageRaw error = GithubApiUtil.fromJson(GithubApiUtil.parseResponse(resp), GithubErrorMessageRaw.class);
                string = method.getStatusText() + " - " + error.getMessage();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getErrorMessage"));
            }
            return string;
        }
        String string = method.getStatusText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getErrorMessage"));
        }
        return string;
    }

    @NotNull
    private static JsonElement parseResponse(@NotNull InputStream githubResponse) throws IOException {
        JsonElement jsonElement;
        if (githubResponse == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "parseResponse"));
        }
        InputStreamReader reader = new InputStreamReader(githubResponse, "UTF-8");
        try {
            JsonElement jsonElement2 = new JsonParser().parse((Reader)reader);
            jsonElement = jsonElement2;
        }
        catch (JsonSyntaxException jse) {
            throw new GithubJsonException("Couldn't parse GitHub response", jse);
        }
        finally {
            ((Reader)reader).close();
        }
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "parseResponse"));
        }
        return jsonElement;
    }

    static <Raw extends DataConstructor, Result> Result createDataFromRaw(@NotNull Raw rawObject, @NotNull Class<Result> resultClass) throws GithubJsonException {
        if (rawObject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "createDataFromRaw"));
        }
        if (resultClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "createDataFromRaw"));
        }
        try {
            return rawObject.create(resultClass);
        }
        catch (Exception e) {
            throw new GithubJsonException("Json parse error", e);
        }
    }

    @NotNull
    private static <T> T fromJson(@Nullable JsonElement json, @NotNull Class<T> classT) throws IOException {
        Object res;
        if (classT == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "fromJson"));
        }
        if (json == null) {
            throw new GithubJsonException("Unexpected empty response");
        }
        try {
            res = gson.fromJson(json, classT);
        }
        catch (ClassCastException e) {
            throw new GithubJsonException("Parse exception while converting JSON to object " + classT.toString(), e);
        }
        catch (JsonParseException e) {
            throw new GithubJsonException("Parse exception while converting JSON to object " + classT.toString(), e);
        }
        if (res == null) {
            throw new GithubJsonException("Empty Json response");
        }
        Object object = res;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "fromJson"));
        }
        return (T)object;
    }

    public static void askForTwoFactorCodeSMS(@NotNull GithubAuthData auth) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "askForTwoFactorCodeSMS"));
        }
        try {
            GithubApiUtil.postRequest(auth, "/authorizations", null, ACCEPT_V3_JSON);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Collection<String> getTokenScopes(@NotNull GithubAuthData auth) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getTokenScopes"));
        }
        HttpMethod method = null;
        String uri = GithubUrlUtil.getApiUrl(auth.getHost()) + "/user";
        method = GithubApiUtil.doREST(auth, uri, null, Collections.<Header>emptyList(), HttpVerb.HEAD);
        GithubApiUtil.checkStatusCode(method);
        Header header = method.getResponseHeader("X-OAuth-Scopes");
        if (header == null) {
            throw new HttpException("No scopes header");
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (HeaderElement elem : header.getElements()) {
            scopes.add(elem.getName());
        }
        ArrayList<String> arrayList = scopes;
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getTokenScopes"));
        }
        return arrayList2;
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @NotNull
    public static String getScopedToken(@NotNull GithubAuthData auth, @NotNull Collection<String> scopes, @NotNull String note) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
        }
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
        }
        GithubAuthorization token = GithubApiUtil.findToken(auth, note);
        if (token == null) {
            String string = GithubApiUtil.getNewScopedToken(auth, scopes, note).getToken();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
            }
            return string;
        }
        if (token.getScopes().containsAll(scopes)) {
            String string = token.getToken();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
            }
            return string;
        }
        String string = GithubApiUtil.updateTokenScopes(auth, token, scopes).getToken();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getScopedToken"));
        }
        return string;
    }

    @NotNull
    private static GithubAuthorization updateTokenScopes(@NotNull GithubAuthData auth, @NotNull GithubAuthorization token, @NotNull Collection<String> scopes) throws IOException {
        GithubAuthorization githubAuthorization;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "updateTokenScopes"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "updateTokenScopes"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "updateTokenScopes"));
        }
        try {
            String path = "/authorizations/" + token.getId();
            GithubAuthorizationUpdateRequest request = new GithubAuthorizationUpdateRequest(new ArrayList<String>(scopes));
            githubAuthorization = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(GithubApiUtil.patchRequest(auth, path, gson.toJson((Object)request), ACCEPT_V3_JSON), GithubAuthorizationRaw.class), GithubAuthorization.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't update token: scopes - " + scopes);
            throw e;
        }
        if (githubAuthorization == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "updateTokenScopes"));
        }
        return githubAuthorization;
    }

    @NotNull
    private static GithubAuthorization getNewScopedToken(@NotNull GithubAuthData auth, @NotNull Collection<String> scopes, @NotNull String note) throws IOException {
        GithubAuthorization githubAuthorization;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getNewScopedToken"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getNewScopedToken"));
        }
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getNewScopedToken"));
        }
        try {
            String path = "/authorizations";
            GithubAuthorizationCreateRequest request = new GithubAuthorizationCreateRequest(new ArrayList<String>(scopes), note, null);
            githubAuthorization = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(GithubApiUtil.postRequest(auth, path, gson.toJson((Object)request), ACCEPT_V3_JSON), GithubAuthorizationRaw.class), GithubAuthorization.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create token: scopes - " + scopes + " - note " + note);
            throw e;
        }
        if (githubAuthorization == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getNewScopedToken"));
        }
        return githubAuthorization;
    }

    @Nullable
    private static GithubAuthorization findToken(@NotNull GithubAuthData auth, @NotNull String note) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "findToken"));
        }
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "findToken"));
        }
        try {
            String path = "/authorizations";
            PagedRequest<GithubAuthorization> request = new PagedRequest<GithubAuthorization>(path, GithubAuthorization.class, GithubAuthorizationRaw[].class, ACCEPT_V3_JSON);
            List<GithubAuthorization> tokens = request.getAll(auth);
            for (GithubAuthorization token : tokens) {
                if (!note.equals(token.getNote())) continue;
                return token;
            }
            return null;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get available tokens");
            throw e;
        }
    }

    @NotNull
    public static String getMasterToken(@NotNull GithubAuthData auth, @NotNull String note) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMasterToken"));
        }
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMasterToken"));
        }
        List<String> scopes = Arrays.asList("repo", "gist");
        String string = GithubApiUtil.getScopedToken(auth, scopes, note);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMasterToken"));
        }
        return string;
    }

    @NotNull
    public static String getReadOnlyToken(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, @NotNull String note) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getReadOnlyToken"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getReadOnlyToken"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getReadOnlyToken"));
        }
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "getReadOnlyToken"));
        }
        GithubRepoDetailed repository = GithubApiUtil.getDetailedRepoInfo(auth, user, repo);
        List<String> scopes = repository.isPrivate() ? Collections.singletonList("repo") : Collections.emptyList();
        String string = GithubApiUtil.getScopedToken(auth, scopes, note);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getReadOnlyToken"));
        }
        return string;
    }

    @NotNull
    public static GithubUser getCurrentUser(@NotNull GithubAuthData auth) throws IOException {
        GithubUser githubUser;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCurrentUser"));
        }
        try {
            JsonElement result = GithubApiUtil.getRequest(auth, "/user", ACCEPT_V3_JSON);
            githubUser = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubUserRaw.class), GithubUser.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user info");
            throw e;
        }
        if (githubUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCurrentUser"));
        }
        return githubUser;
    }

    @NotNull
    public static GithubUserDetailed getCurrentUserDetailed(@NotNull GithubAuthData auth) throws IOException {
        GithubUserDetailed githubUserDetailed;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCurrentUserDetailed"));
        }
        try {
            JsonElement result = GithubApiUtil.getRequest(auth, "/user", ACCEPT_V3_JSON);
            githubUserDetailed = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubUserRaw.class), GithubUserDetailed.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user info");
            throw e;
        }
        if (githubUserDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCurrentUserDetailed"));
        }
        return githubUserDetailed;
    }

    @NotNull
    public static List<GithubRepo> getUserRepos(@NotNull GithubAuthData auth) throws IOException {
        List<GithubRepo> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        try {
            String path = "/user/repos?per_page=100";
            PagedRequest<GithubRepo> request = new PagedRequest<GithubRepo>(path, GithubRepo.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(auth);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user repositories");
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        return list;
    }

    @NotNull
    public static List<GithubRepo> getUserRepos(@NotNull GithubAuthData auth, @NotNull String user) throws IOException {
        List<GithubRepo> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        try {
            String path = "/users/" + user + "/repos?" + PER_PAGE;
            PagedRequest<GithubRepo> request = new PagedRequest<GithubRepo>(path, GithubRepo.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(auth);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get user repositories: " + user);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getUserRepos"));
        }
        return list;
    }

    @NotNull
    public static List<GithubRepo> getAvailableRepos(@NotNull GithubAuthData auth) throws IOException {
        ArrayList<GithubRepo> arrayList;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getAvailableRepos"));
        }
        try {
            ArrayList<GithubRepo> repos = new ArrayList<GithubRepo>();
            repos.addAll(GithubApiUtil.getUserRepos(auth));
            try {
                repos.addAll(GithubApiUtil.getMembershipRepos(auth));
            }
            catch (GithubStatusCodeException ignore) {
                // empty catch block
            }
            try {
                repos.addAll(GithubApiUtil.getWatchedRepos(auth));
            }
            catch (GithubStatusCodeException githubStatusCodeException) {
                // empty catch block
            }
            arrayList = repos;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get available repositories");
            throw e;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getAvailableRepos"));
        }
        return arrayList;
    }

    @NotNull
    public static List<GithubRepoOrg> getMembershipRepos(@NotNull GithubAuthData auth) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMembershipRepos"));
        }
        String orgsPath = "/user/orgs?per_page=100";
        PagedRequest<GithubOrg> orgsRequest = new PagedRequest<GithubOrg>(orgsPath, GithubOrg.class, GithubOrgRaw[].class, new Header[0]);
        ArrayList<GithubRepoOrg> repos = new ArrayList<GithubRepoOrg>();
        for (GithubOrg org : orgsRequest.getAll(auth)) {
            String path = "/orgs/" + org.getLogin() + "/repos?type=member&" + PER_PAGE;
            PagedRequest<GithubRepoOrg> request = new PagedRequest<GithubRepoOrg>(path, GithubRepoOrg.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
            repos.addAll(request.getAll(auth));
        }
        ArrayList<GithubRepoOrg> arrayList = repos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getMembershipRepos"));
        }
        return arrayList;
    }

    @NotNull
    public static List<GithubRepo> getWatchedRepos(@NotNull GithubAuthData auth) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getWatchedRepos"));
        }
        String pathWatched = "/user/subscriptions?per_page=100";
        PagedRequest<GithubRepo> requestWatched = new PagedRequest<GithubRepo>(pathWatched, GithubRepo.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
        List<GithubRepo> list = requestWatched.getAll(auth);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getWatchedRepos"));
        }
        return list;
    }

    @NotNull
    public static GithubRepoDetailed getDetailedRepoInfo(@NotNull GithubAuthData auth, @NotNull String owner, @NotNull String name) throws IOException {
        GithubRepoDetailed githubRepoDetailed;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getDetailedRepoInfo"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getDetailedRepoInfo"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getDetailedRepoInfo"));
        }
        try {
            String request = "/repos/" + owner + "/" + name;
            JsonElement jsonObject = GithubApiUtil.getRequest(auth, request, ACCEPT_V3_JSON);
            githubRepoDetailed = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(jsonObject, GithubRepoRaw.class), GithubRepoDetailed.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get repository info: " + owner + "/" + name);
            throw e;
        }
        if (githubRepoDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getDetailedRepoInfo"));
        }
        return githubRepoDetailed;
    }

    public static void deleteGithubRepository(@NotNull GithubAuthData auth, @NotNull String username, @NotNull String repo) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGithubRepository"));
        }
        if (username == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGithubRepository"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGithubRepository"));
        }
        try {
            String path = "/repos/" + username + "/" + repo;
            GithubApiUtil.deleteRequest(auth, path, new Header[0]);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't delete repository: " + username + "/" + repo);
            throw e;
        }
    }

    public static void deleteGist(@NotNull GithubAuthData auth, @NotNull String id) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGist"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "deleteGist"));
        }
        try {
            String path = "/gists/" + id;
            GithubApiUtil.deleteRequest(auth, path, new Header[0]);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't delete gist: id - " + id);
            throw e;
        }
    }

    @NotNull
    public static GithubGist getGist(@NotNull GithubAuthData auth, @NotNull String id) throws IOException {
        GithubGist githubGist;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getGist"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getGist"));
        }
        try {
            String path = "/gists/" + id;
            JsonElement result = GithubApiUtil.getRequest(auth, path, ACCEPT_V3_JSON);
            githubGist = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubGistRaw.class), GithubGist.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get gist info: id " + id);
            throw e;
        }
        if (githubGist == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getGist"));
        }
        return githubGist;
    }

    @NotNull
    public static GithubGist createGist(@NotNull GithubAuthData auth, @NotNull List<GithubGist.FileContent> contents, @NotNull String description, boolean isPrivate) throws IOException {
        GithubGist githubGist;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "createGist"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "createGist"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "createGist"));
        }
        try {
            String request = gson.toJson((Object)new GithubGistRequest(contents, description, !isPrivate));
            githubGist = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(GithubApiUtil.postRequest(auth, "/gists", request, ACCEPT_V3_JSON), GithubGistRaw.class), GithubGist.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create gist");
            throw e;
        }
        if (githubGist == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "createGist"));
        }
        return githubGist;
    }

    @NotNull
    public static GithubPullRequest createPullRequest(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, @NotNull String title, @NotNull String description, @NotNull String head, @NotNull String base) throws IOException {
        GithubPullRequest githubPullRequest;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (head == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        try {
            String request = gson.toJson((Object)new GithubPullRequestRequest(title, description, head, base));
            githubPullRequest = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(GithubApiUtil.postRequest(auth, "/repos/" + user + "/" + repo + "/pulls", request, ACCEPT_V3_JSON), GithubPullRequestRaw.class), GithubPullRequest.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create pull request");
            throw e;
        }
        if (githubPullRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "createPullRequest"));
        }
        return githubPullRequest;
    }

    @NotNull
    public static GithubRepo createRepo(@NotNull GithubAuthData auth, @NotNull String name, @NotNull String description, boolean isPrivate) throws IOException {
        GithubRepo githubRepo;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "createRepo"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "createRepo"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "createRepo"));
        }
        try {
            String path = "/user/repos";
            GithubRepoRequest request = new GithubRepoRequest(name, description, isPrivate);
            githubRepo = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(GithubApiUtil.postRequest(auth, path, gson.toJson((Object)request), ACCEPT_V3_JSON), GithubRepoRaw.class), GithubRepo.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't create repository: " + name);
            throw e;
        }
        if (githubRepo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "createRepo"));
        }
        return githubRepo;
    }

    @NotNull
    public static List<GithubIssue> getIssuesAssigned(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, @Nullable String assigned, int max) throws IOException {
        ArrayList<GithubIssue> arrayList;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesAssigned"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesAssigned"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesAssigned"));
        }
        try {
            String path = StringUtil.isEmptyOrSpaces((String)assigned) ? "/repos/" + user + "/" + repo + "/issues?" + PER_PAGE : "/repos/" + user + "/" + repo + "/issues?assignee=" + assigned + "&" + PER_PAGE;
            PagedRequest<GithubIssue> request = new PagedRequest<GithubIssue>(path, GithubIssue.class, GithubIssueRaw[].class, ACCEPT_V3_JSON);
            ArrayList<GithubIssue> result = new ArrayList<GithubIssue>();
            while (request.hasNext() && max > result.size()) {
                result.addAll(request.next(auth));
            }
            arrayList = result;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get assigned issues: " + user + "/" + repo + " - " + assigned);
            throw e;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesAssigned"));
        }
        return arrayList;
    }

    @NotNull
    public static List<GithubIssue> getIssuesQueried(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, @Nullable String query) throws IOException {
        List<GithubIssue> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesQueried"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesQueried"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesQueried"));
        }
        try {
            query = URLEncoder.encode("repo:" + user + "/" + repo + " " + query, "UTF-8");
            String path = "/search/issues?q=" + query;
            JsonElement result = GithubApiUtil.getRequest(auth, path, ACCEPT_V3_JSON);
            list = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubIssuesSearchResultRaw.class), GithubIssuesSearchResult.class).getIssues();
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get queried issues: " + user + "/" + repo + " - " + query);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssuesQueried"));
        }
        return list;
    }

    @NotNull
    public static GithubIssue getIssue(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, @NotNull String id) throws IOException {
        GithubIssue githubIssue;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/issues/" + id;
            JsonElement result = GithubApiUtil.getRequest(auth, path, ACCEPT_V3_JSON);
            githubIssue = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubIssueRaw.class), GithubIssue.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get issue info: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (githubIssue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssue"));
        }
        return githubIssue;
    }

    @NotNull
    public static List<GithubIssueComment> getIssueComments(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubIssueComment> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssueComments"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssueComments"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssueComments"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/issues/" + id + "/comments?" + PER_PAGE;
            PagedRequest<GithubIssueComment> request = new PagedRequest<GithubIssueComment>(path, GithubIssueComment.class, GithubIssueCommentRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
            list = request.getAll(auth);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get issue comments: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getIssueComments"));
        }
        return list;
    }

    @NotNull
    public static GithubCommitDetailed getCommit(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, @NotNull String sha) throws IOException {
        GithubCommitDetailed githubCommitDetailed;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        if (sha == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/commits/" + sha;
            JsonElement result = GithubApiUtil.getRequest(auth, path, ACCEPT_V3_JSON);
            githubCommitDetailed = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(result, GithubCommitRaw.class), GithubCommitDetailed.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get commit info: " + user + "/" + repo + " - " + sha);
            throw e;
        }
        if (githubCommitDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommit"));
        }
        return githubCommitDetailed;
    }

    @NotNull
    public static List<GithubCommitComment> getCommitComments(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, @NotNull String sha) throws IOException {
        List<GithubCommitComment> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        if (sha == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/commits/" + sha + "/comments";
            PagedRequest<GithubCommitComment> request = new PagedRequest<GithubCommitComment>(path, GithubCommitComment.class, GithubCommitCommentRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
            list = request.getAll(auth);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get commit comments: " + user + "/" + repo + " - " + sha);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getCommitComments"));
        }
        return list;
    }

    @NotNull
    public static List<GithubCommitComment> getPullRequestComments(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubCommitComment> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestComments"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestComments"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestComments"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id + "/comments";
            PagedRequest<GithubCommitComment> request = new PagedRequest<GithubCommitComment>(path, GithubCommitComment.class, GithubCommitCommentRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
            list = request.getAll(auth);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request comments: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestComments"));
        }
        return list;
    }

    @NotNull
    public static GithubPullRequest getPullRequest(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, int id) throws IOException {
        GithubPullRequest githubPullRequest;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequest"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequest"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequest"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id;
            githubPullRequest = GithubApiUtil.createDataFromRaw((DataConstructor)GithubApiUtil.fromJson(GithubApiUtil.getRequest(auth, path, ACCEPT_V3_JSON_HTML_MARKUP), GithubPullRequestRaw.class), GithubPullRequest.class);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request info: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (githubPullRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequest"));
        }
        return githubPullRequest;
    }

    @NotNull
    public static List<GithubPullRequest> getPullRequests(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo) throws IOException {
        List<GithubPullRequest> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls?" + PER_PAGE;
            PagedRequest<GithubPullRequest> request = new PagedRequest<GithubPullRequest>(path, GithubPullRequest.class, GithubPullRequestRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
            list = request.getAll(auth);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull requests" + user + "/" + repo);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        return list;
    }

    @NotNull
    public static PagedRequest<GithubPullRequest> getPullRequests(@NotNull String user, @NotNull String repo) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        String path = "/repos/" + user + "/" + repo + "/pulls?" + PER_PAGE;
        PagedRequest<GithubPullRequest> pagedRequest = new PagedRequest<GithubPullRequest>(path, GithubPullRequest.class, GithubPullRequestRaw[].class, ACCEPT_V3_JSON_HTML_MARKUP);
        if (pagedRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequests"));
        }
        return pagedRequest;
    }

    @NotNull
    public static List<GithubCommit> getPullRequestCommits(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubCommit> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestCommits"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestCommits"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestCommits"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id + "/commits?" + PER_PAGE;
            PagedRequest<GithubCommit> request = new PagedRequest<GithubCommit>(path, GithubCommit.class, GithubCommitRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(auth);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request commits: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestCommits"));
        }
        return list;
    }

    @NotNull
    public static List<GithubFile> getPullRequestFiles(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, long id) throws IOException {
        List<GithubFile> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestFiles"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestFiles"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestFiles"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/pulls/" + id + "/files?" + PER_PAGE;
            PagedRequest<GithubFile> request = new PagedRequest<GithubFile>(path, GithubFile.class, GithubFileRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(auth);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get pull request files: " + user + "/" + repo + " - " + id);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getPullRequestFiles"));
        }
        return list;
    }

    @NotNull
    public static List<GithubBranch> getRepoBranches(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo) throws IOException {
        List<GithubBranch> list;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRepoBranches"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRepoBranches"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRepoBranches"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/branches?" + PER_PAGE;
            PagedRequest<GithubBranch> request = new PagedRequest<GithubBranch>(path, GithubBranch.class, GithubBranchRaw[].class, ACCEPT_V3_JSON);
            list = request.getAll(auth);
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't get repository branches: " + user + "/" + repo);
            throw e;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil", "getRepoBranches"));
        }
        return list;
    }

    @Nullable
    public static GithubRepo findForkByUser(@NotNull GithubAuthData auth, @NotNull String user, @NotNull String repo, @NotNull String forkUser) throws IOException {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil", "findForkByUser"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil", "findForkByUser"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil", "findForkByUser"));
        }
        if (forkUser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil", "findForkByUser"));
        }
        try {
            String path = "/repos/" + user + "/" + repo + "/forks?" + PER_PAGE;
            PagedRequest<GithubRepo> request = new PagedRequest<GithubRepo>(path, GithubRepo.class, GithubRepoRaw[].class, ACCEPT_V3_JSON);
            while (request.hasNext()) {
                for (GithubRepo fork : request.next(auth)) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)fork.getUserName(), (CharSequence)forkUser)) continue;
                    return fork;
                }
            }
            return null;
        }
        catch (GithubConfusingException e) {
            e.setDetails("Can't find fork by user: " + user + "/" + repo + " - " + forkUser);
            throw e;
        }
    }

    public static class PagedRequest<T> {
        @Nullable
        private String myNextPage;
        @NotNull
        private final Collection<Header> myHeaders;
        @NotNull
        private final Class<T> myResult;
        @NotNull
        private final Class<? extends DataConstructor[]> myRawArray;

        public PagedRequest(@NotNull String path, @NotNull Class<T> result, @NotNull Class<? extends DataConstructor[]> rawArray, Header ... headers) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil$PagedRequest", "<init>"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/github/api/GithubApiUtil$PagedRequest", "<init>"));
            }
            if (rawArray == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/github/api/GithubApiUtil$PagedRequest", "<init>"));
            }
            if (headers == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/github/api/GithubApiUtil$PagedRequest", "<init>"));
            }
            this.myNextPage = path;
            this.myResult = result;
            this.myRawArray = rawArray;
            this.myHeaders = Arrays.asList(headers);
        }

        @NotNull
        public List<T> next(@NotNull GithubAuthData auth) throws IOException {
            if (auth == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil$PagedRequest", "next"));
            }
            if (this.myNextPage == null) {
                throw new NoSuchElementException();
            }
            String page = this.myNextPage;
            this.myNextPage = null;
            ResponsePage response = GithubApiUtil.request(auth, page, null, this.myHeaders, HttpVerb.GET);
            if (response.getJsonElement() == null) {
                throw new HttpException("Empty response");
            }
            if (!response.getJsonElement().isJsonArray()) {
                throw new GithubJsonException("Wrong json type: expected JsonArray", new Exception(response.getJsonElement().toString()));
            }
            this.myNextPage = response.getNextPage();
            ArrayList<T> result = new ArrayList<T>();
            for (DataConstructor raw : (DataConstructor[])GithubApiUtil.fromJson((JsonElement)response.getJsonElement().getAsJsonArray(), this.myRawArray)) {
                result.add(GithubApiUtil.createDataFromRaw(raw, this.myResult));
            }
            ArrayList<T> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil$PagedRequest", "next"));
            }
            return arrayList;
        }

        public boolean hasNext() {
            return this.myNextPage != null;
        }

        @NotNull
        public List<T> getAll(@NotNull GithubAuthData auth) throws IOException {
            if (auth == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/github/api/GithubApiUtil$PagedRequest", "getAll"));
            }
            ArrayList<T> result = new ArrayList<T>();
            while (this.hasNext()) {
                result.addAll(this.next(auth));
            }
            ArrayList<T> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubApiUtil$PagedRequest", "getAll"));
            }
            return arrayList;
        }
    }

    private static class ResponsePage {
        @Nullable
        private final JsonElement response;
        @Nullable
        private final String nextPage;

        public ResponsePage() {
            this(null, null);
        }

        public ResponsePage(@Nullable JsonElement response) {
            this(response, null);
        }

        public ResponsePage(@Nullable JsonElement response, @Nullable String next) {
            this.response = response;
            this.nextPage = next;
        }

        @Nullable
        public JsonElement getJsonElement() {
            return this.response;
        }

        @Nullable
        public String getNextPage() {
            return this.nextPage;
        }
    }

    private static enum HttpVerb {
        GET,
        POST,
        DELETE,
        HEAD,
        PATCH;

    }
}

