/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class DocPackage
extends MajorRevisionPackage
implements IAndroidVersionProvider {
    private final AndroidVersion mVersion;
    private final IPkgDesc mPkgDesc;

    public DocPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        int apiLevel = PackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = PackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
        this.mPkgDesc = PkgDesc.Builder.newDoc(this.mVersion, (MajorRevision)this.getRevision()).setDescriptions(this).create();
    }

    public static Package create(SdkSource source, Properties props, int apiLevel, String codename, int revision, String license, String description, String descUrl, String archiveOsPath) {
        return new DocPackage(source, props, apiLevel, codename, revision, license, description, descUrl, archiveOsPath);
    }

    private DocPackage(SdkSource source, Properties props, int apiLevel, String codename, int revision, String license, String description, String descUrl, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOsPath);
        this.mVersion = new AndroidVersion(props, apiLevel, codename);
        this.mPkgDesc = PkgDesc.Builder.newDoc(this.mVersion, (MajorRevision)this.getRevision()).setDescriptions(this).create();
    }

    @Override
    @NonNull
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    @Override
    public String installId() {
        return "doc-" + this.mVersion.getApiString();
    }

    @Override
    public String getListDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s%2$s", ld, this.isObsolete() ? " (Obsolete)" : "");
        }
        if (this.mVersion.isPreview()) {
            return String.format("Documentation for Android '%1$s' Preview SDK%2$s", this.mVersion.getCodename(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Documentation for Android SDK%2$s", this.mVersion.getApiLevel(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", ld, this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        if (this.mVersion.isPreview()) {
            return String.format("Documentation for Android '%1$s' Preview SDK, revision %2$s%3$s", this.mVersion.getCodename(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Documentation for Android SDK, API %1$d, revision %2$s%3$s", this.mVersion.getApiLevel(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        return new File(osSdkRoot, "docs");
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof DocPackage) {
            AndroidVersion rev2 = ((DocPackage)pkg).getAndroidVersion();
            return this.getAndroidVersion().equals(rev2);
        }
        return false;
    }

    @Override
    public Package.UpdateInfo canBeUpdatedBy(Package replacementPackage) {
        if (!(replacementPackage instanceof DocPackage)) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        DocPackage replacementDoc = (DocPackage)replacementPackage;
        AndroidVersion replacementVersion = replacementDoc.getAndroidVersion();
        if (replacementVersion.equals(this.mVersion) ? replacementPackage.getRevision().compareTo(this.getRevision()) > 0 : replacementVersion.getApiLevel() == this.mVersion.getApiLevel() && replacementVersion.isPreview()) {
            return Package.UpdateInfo.UPDATE;
        }
        return Package.UpdateInfo.NOT_UPDATE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DocPackage)) {
            return false;
        }
        DocPackage other = (DocPackage)obj;
        return !(this.mVersion == null ? other.mVersion != null : !this.mVersion.equals(other.mVersion));
    }
}

