/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.maven.wizards.MavenProjectBuilder;

public class SelectProfilesStep
extends ProjectImportWizardStep {
    private JPanel panel;
    private ElementsChooser<String> profileChooser;

    public SelectProfilesStep(WizardContext context) {
        super(context);
        this.$$$setupUI$$$();
    }

    public boolean isStepVisible() {
        if (!super.isStepVisible()) {
            return false;
        }
        MavenProjectBuilder importBuilder = this.getBuilder();
        if (importBuilder != null) {
            return !importBuilder.getProfiles().isEmpty();
        }
        return false;
    }

    protected MavenProjectBuilder getBuilder() {
        return (MavenProjectBuilder)super.getBuilder();
    }

    public void createUIComponents() {
        this.profileChooser = new ElementsChooser(true);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updateStep() {
        List<String> allProfiles = this.getBuilder().getProfiles();
        ArrayList<String> markedProfiles = new ArrayList<String>(this.getBuilder().getSelectedProfiles());
        markedProfiles.retainAll(allProfiles);
        this.profileChooser.setElements(allProfiles, false);
        this.profileChooser.markElements(markedProfiles);
    }

    public boolean validate() throws ConfigurationException {
        return this.getBuilder().setSelectedProfiles(this.profileChooser.getMarkedElements());
    }

    public void updateDataModel() {
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.import.maven.page2";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(8, 8, 8, 8), -1, -1, false, false));
        ElementsChooser<String> elementsChooser = this.profileChooser;
        jPanel.add((Component)elementsChooser, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Select profiles:");
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

