/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import icons.MavenIcons;
import java.io.IOException;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;

public class MavenFrameworkSupportProvider
extends FrameworkSupportProvider {
    public MavenFrameworkSupportProvider() {
        super(MavenFrameworkSupportProvider.class.getName(), "Maven");
    }

    @NotNull
    public FrameworkSupportConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider", "createConfigurable"));
        }
        FrameworkSupportConfigurable frameworkSupportConfigurable = new FrameworkSupportConfigurable(){

            public JComponent getComponent() {
                return new JPanel();
            }

            public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel model, @Nullable Library library) {
                VirtualFile root;
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider$1", "addSupport"));
                }
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider$1", "addSupport"));
                }
                VirtualFile[] roots = model.getContentRoots();
                if (roots.length == 0) {
                    root = module.getModuleFile().getParent();
                    model.addContentEntry(root);
                } else {
                    root = roots[0];
                }
                VirtualFile existingPom = root.findChild("pom.xml");
                if (existingPom != null) {
                    MavenProjectsManager.getInstance(module.getProject()).addManagedFilesOrUnignore(Collections.singletonList(existingPom));
                } else {
                    MavenFrameworkSupportProvider.prepareProjectStructure(model, root);
                    new MavenModuleBuilderHelper(new MavenId("groupId", module.getName(), "1.0-SNAPSHOT"), null, null, false, false, null, null, "Add Maven Support").configure(model.getProject(), root, true);
                }
            }
        };
        if (frameworkSupportConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider", "createConfigurable"));
        }
        return frameworkSupportConfigurable;
    }

    private static void prepareProjectStructure(@NotNull ModifiableRootModel model, @NotNull VirtualFile root) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider", "prepareProjectStructure"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider", "prepareProjectStructure"));
        }
        VirtualFile src = root.findChild("src");
        if (src == null || !src.isDirectory()) {
            return;
        }
        if (ArrayUtil.contains((Object)src, (Object[])model.getSourceRoots())) {
            try {
                VirtualFile java = VfsUtil.createDirectories((String)(src.getPath() + "/main/java"));
                if (java != null && java.isDirectory()) {
                    for (VirtualFile child : src.getChildren()) {
                        if (child.getName().equals("main")) continue;
                        child.move(null, java);
                    }
                }
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
    }

    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider", "isEnabledForModuleBuilder"));
        }
        return false;
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider", "isSupportAlreadyAdded"));
        }
        return MavenProjectsManager.getInstance(module.getProject()).isMavenizedModule(module);
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/wizards/MavenFrameworkSupportProvider", "isEnabledForModuleType"));
        }
        return moduleType.equals((Object)StdModuleTypes.JAVA);
    }

    public Icon getIcon() {
        return MavenIcons.MavenLogo;
    }
}

