/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.services;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.services.MavenRepositoryService;
import org.jetbrains.idea.maven.services.artifactory.ArtifactoryRepositoryService;
import org.jetbrains.idea.maven.services.nexus.NexusRepositoryService;
import org.jetbrains.idea.maven.utils.MavenLog;

@State(name="MavenServices", storages={@Storage(file="$APP_CONFIG$/mavenServices.xml")})
public class MavenRepositoryServicesManager
implements PersistentStateComponent<Element> {
    private final List<String> myUrls = new ArrayList<String>();

    @NotNull
    public static MavenRepositoryServicesManager getInstance() {
        MavenRepositoryServicesManager mavenRepositoryServicesManager = (MavenRepositoryServicesManager)ServiceManager.getService(MavenRepositoryServicesManager.class);
        if (mavenRepositoryServicesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "getInstance"));
        }
        return mavenRepositoryServicesManager;
    }

    @NotNull
    public static MavenRepositoryService[] getServices() {
        MavenRepositoryService[] mavenRepositoryServiceArray = new MavenRepositoryService[]{new NexusRepositoryService(), new ArtifactoryRepositoryService()};
        if (mavenRepositoryServiceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "getServices"));
        }
        return mavenRepositoryServiceArray;
    }

    public static String[] getServiceUrls() {
        List<String> configured = MavenRepositoryServicesManager.getInstance().getUrls();
        if (!configured.isEmpty()) {
            return ArrayUtil.toStringArray(configured);
        }
        return new String[]{"http://oss.sonatype.org/service/local/", "http://repo.jfrog.org/artifactory/api/", "https://repository.jboss.org/nexus/service/local/"};
    }

    public List<String> getUrls() {
        return this.myUrls;
    }

    public void setUrls(List<String> urls) {
        this.myUrls.clear();
        this.myUrls.addAll(urls);
    }

    public Element getState() {
        Element element = new Element("maven-services");
        for (String url : this.myUrls) {
            Element child = new Element("service-url");
            child.setText(StringUtil.escapeXml((String)url));
            element.addContent(child);
        }
        return element;
    }

    public void loadState(Element state) {
        this.myUrls.clear();
        for (Element element : state.getChildren("service-url")) {
            this.myUrls.add(StringUtil.unescapeXml((String)element.getTextTrim()));
        }
    }

    @NotNull
    public static List<MavenRepositoryInfo> getRepositories(String url) {
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.getRepositories(url));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "getRepositories"));
        }
        return smartList;
    }

    @NotNull
    public static List<MavenArtifactInfo> findArtifacts(@NotNull MavenArtifactInfo template, @NotNull String url) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "findArtifacts"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "findArtifacts"));
        }
        SmartList result = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result.addAll(service.findArtifacts(url, template));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/services/MavenRepositoryServicesManager", "findArtifacts"));
        }
        return smartList;
    }
}

