/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.project.MavenDisablePanelCheckbox;
import org.jetbrains.idea.maven.project.MavenGeneralPanel;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenGeneralSettingsEditor
extends SettingsEditor<MavenRunConfiguration> {
    private final MavenGeneralPanel myPanel;
    private JCheckBox myUseProjectSettings;
    private final Project myProject;

    public MavenGeneralSettingsEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/project/MavenGeneralSettingsEditor", "<init>"));
        }
        this.myProject = project;
        this.myPanel = new MavenGeneralPanel();
    }

    protected void resetEditorFrom(MavenRunConfiguration s) {
        this.myUseProjectSettings.setSelected(s.getGeneralSettings() == null);
        if (s.getGeneralSettings() == null) {
            MavenGeneralSettings settings = MavenProjectsManager.getInstance(this.myProject).getGeneralSettings();
            this.myPanel.getData(settings);
        } else {
            this.myPanel.getData(s.getGeneralSettings());
        }
    }

    protected void applyEditorTo(MavenRunConfiguration s) throws ConfigurationException {
        if (this.myUseProjectSettings.isSelected()) {
            s.setGeneralSettings(null);
        } else {
            MavenGeneralSettings state = s.getGeneralSettings();
            if (state != null) {
                this.myPanel.setData(state);
            } else {
                MavenGeneralSettings settings = MavenProjectsManager.getInstance(this.myProject).getGeneralSettings().clone();
                this.myPanel.setData(settings);
                s.setGeneralSettings(settings);
            }
        }
    }

    @NotNull
    protected JComponent createEditor() {
        Pair<JPanel, JCheckBox> pair = MavenDisablePanelCheckbox.createPanel(this.myPanel.createComponent(), "Use project settings");
        this.myUseProjectSettings = (JCheckBox)pair.second;
        JComponent jComponent = (JComponent)pair.first;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenGeneralSettingsEditor", "createEditor"));
        }
        return jComponent;
    }

    protected void disposeEditor() {
        this.myPanel.disposeUIResources();
    }

    public Project getProject() {
        return this.myProject;
    }
}

