/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public abstract class MavenTreeAction
extends MavenAction {
    @Override
    protected boolean isAvailable(AnActionEvent e) {
        return super.isAvailable(e) && MavenActionUtil.isMavenizedProject(e.getDataContext()) && MavenTreeAction.getTree(e) != null;
    }

    @Nullable
    protected static JTree getTree(AnActionEvent e) {
        return (JTree)MavenDataKeys.MAVEN_PROJECTS_TREE.getData(e.getDataContext());
    }

    public static class ExpandAll
    extends MavenTreeAction {
        public void actionPerformed(AnActionEvent e) {
            JTree tree = ExpandAll.getTree(e);
            if (tree == null) {
                return;
            }
            for (int i = 0; i < tree.getRowCount(); ++i) {
                tree.expandRow(i);
            }
        }
    }

    public static class CollapseAll
    extends MavenTreeAction {
        public void actionPerformed(AnActionEvent e) {
            JTree tree = CollapseAll.getTree(e);
            if (tree == null) {
                return;
            }
            for (int row = tree.getRowCount() - 1; row >= 0; --row) {
                tree.collapseRow(row);
            }
        }
    }
}

