/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public class MavenNavigationUtil {
    private static final String ARTIFACT_ID = "artifactId";

    private MavenNavigationUtil() {
    }

    @Nullable
    public static Navigatable createNavigatableForPom(final Project project, final VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        final PsiFile result = PsiManager.getInstance((Project)project).findFile(file);
        return result == null ? null : new NavigatableAdapter(){

            public void navigate(boolean requestFocus) {
                XmlTag[] id;
                XmlTag rootTag;
                XmlDocument xml;
                int offset = 0;
                if (result instanceof XmlFile && (xml = ((XmlFile)result).getDocument()) != null && (rootTag = xml.getRootTag()) != null && (id = rootTag.findSubTags(MavenNavigationUtil.ARTIFACT_ID, rootTag.getNamespace())).length > 0) {
                    offset = id[0].getValue().getTextRange().getStartOffset();
                }
                1.navigate((Project)project, (VirtualFile)file, (int)offset, (boolean)requestFocus);
            }
        };
    }

    @Nullable
    public static Navigatable createNavigatableForDependency(final Project project, final VirtualFile file, final MavenArtifact artifact) {
        return new NavigatableAdapter(){

            public void navigate(boolean requestFocus) {
                if (!file.isValid()) {
                    return;
                }
                MavenDomProjectModel projectModel = MavenDomUtil.getMavenDomProjectModel(project, file);
                if (projectModel == null) {
                    return;
                }
                MavenDomDependency dependency = MavenNavigationUtil.findDependency(projectModel, artifact.getGroupId(), artifact.getArtifactId());
                if (dependency == null) {
                    return;
                }
                XmlTag artifactId = dependency.getArtifactId().getXmlTag();
                if (artifactId == null) {
                    return;
                }
                2.navigate((Project)project, (VirtualFile)artifactId.getContainingFile().getVirtualFile(), (int)(artifactId.getTextOffset() + artifactId.getName().length() + 2), (boolean)requestFocus);
            }
        };
    }

    @Nullable
    public static VirtualFile getArtifactFile(Project project, MavenId id) {
        File file = MavenArtifactUtil.getArtifactFile(MavenProjectsManager.getInstance(project).getLocalRepository(), id);
        return file.exists() ? LocalFileSystem.getInstance().findFileByIoFile(file) : null;
    }

    @Nullable
    public static MavenDomDependency findDependency(@NotNull MavenDomProjectModel projectDom, final String groupId, final String artifactId) {
        if (projectDom == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/navigator/MavenNavigationUtil", "findDependency"));
        }
        MavenDomProjectProcessorUtils.SearchProcessor<MavenDomDependency, MavenDomDependencies> processor = new MavenDomProjectProcessorUtils.SearchProcessor<MavenDomDependency, MavenDomDependencies>(){

            @Override
            @Nullable
            protected MavenDomDependency find(MavenDomDependencies element) {
                for (MavenDomDependency dependency : element.getDependencies()) {
                    if (!Comparing.equal((String)groupId, (String)dependency.getGroupId().getStringValue()) || !Comparing.equal((String)artifactId, (String)dependency.getArtifactId().getStringValue())) continue;
                    return dependency;
                }
                return null;
            }
        };
        MavenDomProjectProcessorUtils.processDependencies(projectDom, (Processor<MavenDomDependencies>)processor);
        return (MavenDomDependency)processor.getResult();
    }
}

