/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenEncodingConfigurer
extends MavenModuleConfigurer {
    @Override
    public void configure(@NotNull MavenProject mavenProject, @NotNull Project project, @Nullable Module module) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/importing/configurers/MavenEncodingConfigurer", "configure"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/importing/configurers/MavenEncodingConfigurer", "configure"));
        }
        String encoding = mavenProject.getEncoding();
        if (encoding != null) {
            try {
                EncodingProjectManager.getInstance((Project)project).setEncoding(mavenProject.getDirectoryFile(), Charset.forName(encoding));
            }
            catch (UnsupportedCharsetException ignored) {
            }
            catch (IllegalCharsetNameException ignored) {
                // empty catch block
            }
        }
    }
}

