/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.cmd;

public class ParametersListLexer {
    private final String myText;
    private int myTokenStart = -1;
    private int index = 0;

    public ParametersListLexer(String text) {
        this.myText = text;
    }

    public int getTokenStart() {
        assert (this.myTokenStart >= 0);
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        assert (this.myTokenStart >= 0);
        return this.index;
    }

    public String getCurrentToken() {
        return this.myText.substring(this.myTokenStart, this.index);
    }

    public boolean nextToken() {
        int i;
        for (i = this.index; i < this.myText.length() && Character.isWhitespace(this.myText.charAt(i)); ++i) {
        }
        if (i == this.myText.length()) {
            return false;
        }
        this.myTokenStart = i;
        boolean isInQuote = false;
        do {
            char a = this.myText.charAt(i);
            if (!isInQuote && Character.isWhitespace(a)) break;
            if (a == '\\' && i + 1 < this.myText.length() && this.myText.charAt(i + 1) == '\"') {
                i += 2;
                continue;
            }
            if (a == '\"') {
                ++i;
                isInQuote = !isInQuote;
                continue;
            }
            ++i;
        } while (i < this.myText.length());
        this.index = i;
        return true;
    }
}

