/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunnerPanel;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;

public abstract class MavenRunnerConfigurable
extends MavenRunnerPanel
implements SearchableConfigurable,
Configurable.NoScroll {
    public MavenRunnerConfigurable(@NotNull Project p, boolean isRunConfiguration) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/execution/MavenRunnerConfigurable", "<init>"));
        }
        super(p, isRunConfiguration);
    }

    @Nullable
    protected abstract MavenRunnerSettings getState();

    public boolean isModified() {
        MavenRunnerSettings s = new MavenRunnerSettings();
        this.setData(s);
        return !s.equals(this.getState());
    }

    public void apply() throws ConfigurationException {
        this.setData(this.getState());
    }

    public void reset() {
        this.getData(this.getState());
    }

    @Nls
    public String getDisplayName() {
        return RunnerBundle.message("maven.tab.runner", new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.maven.runner";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunnerConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public void disposeUIResources() {
    }
}

