/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExecutor;
import org.jetbrains.idea.maven.execution.MavenExternalExecutor;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.SoutMavenConsole;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenConsoleImpl;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;

@State(name="MavenRunner", storages={@Storage(file="$WORKSPACE_FILE$")})
public class MavenRunner
implements PersistentStateComponent<MavenRunnerSettings> {
    private static final Logger LOG = Logger.getInstance(MavenRunner.class);
    private MavenRunnerSettings mySettings = new MavenRunnerSettings();
    private final Project myProject;

    public static MavenRunner getInstance(Project project) {
        return (MavenRunner)ServiceManager.getService((Project)project, MavenRunner.class);
    }

    public MavenRunner(Project project) {
        this.myProject = project;
    }

    public MavenRunnerSettings getSettings() {
        return this.mySettings;
    }

    @NotNull
    public MavenRunnerSettings getState() {
        MavenRunnerSettings mavenRunnerSettings = this.mySettings;
        if (mavenRunnerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunner", "getState"));
        }
        return mavenRunnerSettings;
    }

    public void loadState(MavenRunnerSettings settings) {
        this.mySettings = settings;
    }

    public void run(MavenRunnerParameters parameters, final MavenRunnerSettings settings, final Runnable onComplete) {
        FileDocumentManager.getInstance().saveAllDocuments();
        final MavenConsole console = this.createConsole();
        try {
            final MavenExecutor[] executor = new MavenExecutor[]{this.createExecutor(parameters, null, settings, console)};
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, executor[0].getCaption(), true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/execution/MavenRunner$1", "run"));
                    }
                    try {
                        try {
                            if (executor[0].execute(indicator) && onComplete != null) {
                                onComplete.run();
                            }
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                        executor[0] = null;
                        MavenRunner.this.updateTargetFolders();
                    }
                    finally {
                        console.finish();
                    }
                }

                @Nullable
                public Task.NotificationInfo getNotificationInfo() {
                    return new Task.NotificationInfo("Maven", "Maven Task Finished", "");
                }

                public boolean shouldStartInBackground() {
                    return settings.isRunMavenInBackground();
                }

                public void processSentToBackground() {
                    settings.setRunMavenInBackground(true);
                }

                public void processRestoredToForeground() {
                    settings.setRunMavenInBackground(false);
                }
            });
        }
        catch (Exception e) {
            console.printException(e);
            console.finish();
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runBatch(List<MavenRunnerParameters> commands, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @Nullable String action, @Nullable ProgressIndicator indicator) {
        MavenConsole console;
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed());
        if (commands.isEmpty()) {
            return true;
        }
        AccessToken accessToken = ReadAction.start();
        try {
            if (this.myProject.isDisposed()) {
                boolean bl = false;
                return bl;
            }
            console = this.createConsole();
        }
        finally {
            accessToken.finish();
        }
        try {
            int count = 0;
            for (MavenRunnerParameters command : commands) {
                MavenExecutor executor;
                if (indicator != null) {
                    indicator.setFraction((double)count++ / (double)commands.size());
                }
                accessToken = ReadAction.start();
                try {
                    if (this.myProject.isDisposed()) break;
                    executor = this.createExecutor(command, coreSettings, runnerSettings, console);
                }
                finally {
                    accessToken.finish();
                }
                executor.setAction(action);
                if (executor.execute(indicator)) continue;
                this.updateTargetFolders();
                boolean bl = false;
                return bl;
            }
            this.updateTargetFolders();
        }
        finally {
            console.finish();
        }
        return true;
    }

    private void updateTargetFolders() {
        if (this.myProject.isDisposed()) {
            return;
        }
        MavenProjectsManager.getInstance(this.myProject).updateProjectTargetFolders();
    }

    private MavenConsole createConsole() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new SoutMavenConsole();
        }
        return new MavenConsoleImpl("Maven Goal", this.myProject);
    }

    private MavenExecutor createExecutor(MavenRunnerParameters taskParameters, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, MavenConsole console) {
        return new MavenExternalExecutor(this.myProject, taskParameters, coreSettings, runnerSettings, console);
    }
}

