/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenOrderEnumeratorHandler
extends OrderEnumerationHandler {
    private static final MavenOrderEnumeratorHandler INSTANCE = new MavenOrderEnumeratorHandler();

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return true;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return false;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return false;
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        public boolean isApplicable(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/execution/MavenOrderEnumeratorHandler$FactoryImpl", "isApplicable"));
            }
            return MavenProjectsManager.getInstance(project).isMavenizedProject();
        }

        public boolean isApplicable(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/execution/MavenOrderEnumeratorHandler$FactoryImpl", "isApplicable"));
            }
            MavenProjectsManager manager = MavenProjectsManager.getInstance(module.getProject());
            return manager.isMavenizedModule(module);
        }

        public OrderEnumerationHandler createHandler(@Nullable Module module) {
            return INSTANCE;
        }
    }
}

