/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenGoalLocation;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenConfigurationProducer
extends RuntimeConfigurationProducer {
    private PsiElement myPsiElement;

    public MavenConfigurationProducer() {
        super((ConfigurationType)MavenRunConfigurationType.getInstance());
    }

    public PsiElement getSourceElement() {
        return this.myPsiElement;
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        this.myPsiElement = location.getPsiElement();
        MavenRunnerParameters params = MavenConfigurationProducer.createBuildParameters(location);
        if (params == null) {
            return null;
        }
        return MavenRunConfigurationType.createRunnerAndConfigurationSettings(null, null, params, location.getProject());
    }

    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        if (existingConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/execution/MavenConfigurationProducer", "findExistingByElement"));
        }
        MavenRunnerParameters runnerParameters = MavenConfigurationProducer.createBuildParameters(location);
        for (RunnerAndConfigurationSettings existingConfiguration : existingConfigurations) {
            RunConfiguration configuration = existingConfiguration.getConfiguration();
            if (!(configuration instanceof MavenRunConfiguration) || !((MavenRunConfiguration)configuration).getRunnerParameters().equals(runnerParameters)) continue;
            return existingConfiguration;
        }
        return null;
    }

    private static MavenRunnerParameters createBuildParameters(Location l) {
        if (!(l instanceof MavenGoalLocation)) {
            return null;
        }
        VirtualFile f = ((PsiFile)l.getPsiElement()).getVirtualFile();
        List<String> goals = ((MavenGoalLocation)l).getGoals();
        Collection<String> profiles = MavenProjectsManager.getInstance(l.getProject()).getExplicitProfiles();
        return new MavenRunnerParameters(true, f.getParent().getPath(), goals, profiles);
    }

    public int compareTo(Object o) {
        return -1;
    }
}

