/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.extract;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public class SelectMavenProjectDialog
extends DialogWrapper {
    private final Set<MavenDomProjectModel> myMavenDomProjectModels;
    private final boolean myHasExclusions;
    private JComboBox myMavenProjectsComboBox;
    private JPanel myMainPanel;
    private JCheckBox myReplaceAllCheckBox;
    private JCheckBox myExtractExclusions;
    private boolean myHasUsagesInProjects;
    private ItemListener myReplaceAllListener;
    private final Function<MavenDomProjectModel, Set<MavenDomDependency>> myOccurrencesCountFunction;

    public SelectMavenProjectDialog(@NotNull Project project, @NotNull Set<MavenDomProjectModel> mavenDomProjectModels, @NotNull Function<MavenDomProjectModel, Set<MavenDomDependency>> funOccurrences, @NotNull boolean hasExclusions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/refactorings/extract/SelectMavenProjectDialog", "<init>"));
        }
        if (mavenDomProjectModels == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/refactorings/extract/SelectMavenProjectDialog", "<init>"));
        }
        if (funOccurrences == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/dom/refactorings/extract/SelectMavenProjectDialog", "<init>"));
        }
        super(project, true);
        this.myHasUsagesInProjects = false;
        this.myMavenDomProjectModels = mavenDomProjectModels;
        this.myHasExclusions = hasExclusions;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(MavenDomBundle.message("choose.project", objectArray));
        this.myOccurrencesCountFunction = funOccurrences;
        for (MavenDomProjectModel model : this.myMavenDomProjectModels) {
            if (((Set)this.myOccurrencesCountFunction.fun((Object)model)).size() <= 0) continue;
            this.myHasUsagesInProjects = true;
            break;
        }
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/refactorings/extract/SelectMavenProjectDialog", "createActions"));
        }
        return actionArray;
    }

    protected void init() {
        super.init();
        this.updateOkStatus();
    }

    protected void dispose() {
        super.dispose();
        if (this.myReplaceAllCheckBox != null) {
            this.myReplaceAllCheckBox.removeItemListener(this.myReplaceAllListener);
        }
    }

    @Nullable
    public MavenDomProjectModel getSelectedProject() {
        return (MavenDomProjectModel)ComboBoxUtil.getSelectedValue((DefaultComboBoxModel)this.myMavenProjectsComboBox.getModel());
    }

    public boolean isReplaceAllOccurrences() {
        return this.myReplaceAllCheckBox.isSelected();
    }

    public boolean isExtractExclusions() {
        return this.myExtractExclusions.isSelected();
    }

    protected JComponent createCenterPanel() {
        ComboBoxUtil.setModel(this.myMavenProjectsComboBox, new DefaultComboBoxModel(), this.myMavenDomProjectModels, new Function<MavenDomProjectModel, Pair<String, ?>>(){

            public Pair<String, ?> fun(MavenDomProjectModel model) {
                String projectName = model.getName().getStringValue();
                MavenProject mavenProject = MavenDomUtil.findProject(model);
                if (mavenProject != null) {
                    projectName = mavenProject.getDisplayName();
                }
                if (StringUtil.isEmptyOrSpaces((String)projectName)) {
                    projectName = "pom.xml";
                }
                return Pair.create((Object)projectName, (Object)model);
            }
        });
        this.myReplaceAllListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectMavenProjectDialog.this.updateControls();
            }
        };
        this.myMavenProjectsComboBox.addItemListener(this.myReplaceAllListener);
        this.myMavenProjectsComboBox.setSelectedItem(0);
        this.myReplaceAllCheckBox.setVisible(this.myHasUsagesInProjects);
        this.myExtractExclusions.setVisible(this.myHasExclusions);
        this.updateControls();
        return this.myMainPanel;
    }

    private void updateControls() {
        MavenDomProjectModel project = this.getSelectedProject();
        Integer count = ((Set)this.myOccurrencesCountFunction.fun((Object)project)).size();
        this.myReplaceAllCheckBox.setText(RefactoringBundle.message((String)"replace.all.occurences", (Object[])new Object[]{count}));
        this.myReplaceAllCheckBox.setEnabled(count != 0);
    }

    private void updateOkStatus() {
        this.setOKActionEnabled(this.getSelectedProject() != null);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMavenProjectsComboBox;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Project");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMavenProjectsComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myReplaceAllCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Replace All");
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myExtractExclusions = jCheckBox = new JCheckBox();
        jCheckBox.setText("Extract exclusions");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

