/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;

public class MavenDependenciesCompletionProvider
extends CompletionContributor {
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        PsiElement xmlText = parameters.getPosition().getParent();
        if (!(xmlText instanceof XmlText)) {
            return;
        }
        PsiElement eDependencyTag = xmlText.getParent();
        if (!(eDependencyTag instanceof XmlTag)) {
            return;
        }
        XmlTag dependencyTag = (XmlTag)eDependencyTag;
        if (!"dependency".equals(dependencyTag.getName())) {
            return;
        }
        if (!PsiImplUtil.isLeafElementOfType((PsiElement)xmlText.getPrevSibling(), (IElementType)XmlTokenType.XML_TAG_END) || !PsiImplUtil.isLeafElementOfType((PsiElement)xmlText.getNextSibling(), (IElementType)XmlTokenType.XML_END_TAG_START)) {
            return;
        }
        Project project = dependencyTag.getProject();
        DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(dependencyTag);
        if (!(domElement instanceof MavenDomDependency)) {
            return;
        }
        MavenProjectIndicesManager indicesManager = MavenProjectIndicesManager.getInstance(project);
        for (String groupId : indicesManager.getGroupIds()) {
            for (String artifactId : indicesManager.getArtifactIds(groupId)) {
                LookupElementBuilder builder = LookupElementBuilder.create((String)(groupId + ':' + artifactId)).withIcon(AllIcons.Nodes.PpLib).withInsertHandler(MavenDependencyInsertHandler.INSTANCE);
                result.addElement((LookupElement)builder);
            }
        }
    }

    private static class MavenDependencyInsertHandler
    implements InsertHandler<LookupElement> {
        public static final InsertHandler<LookupElement> INSTANCE = new MavenDependencyInsertHandler();

        private MavenDependencyInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            PsiElement e;
            String s = item.getLookupString();
            int idx = s.indexOf(58);
            String groupId = s.substring(0, idx);
            String artifactId = s.substring(idx + 1);
            int startOffset = context.getStartOffset();
            PsiFile psiFile = context.getFile();
            DomFileElement domModel = DomManager.getDomManager((Project)context.getProject()).getFileElement((XmlFile)psiFile, MavenDomProjectModel.class);
            if (domModel == null) {
                return;
            }
            boolean shouldInvokeCompletion = false;
            MavenDomDependency managedDependency = MavenDependencyCompletionUtil.findManagedDependency((MavenDomProjectModel)domModel.getRootElement(), context.getProject(), groupId, artifactId);
            if (managedDependency == null) {
                String value = "<groupId>" + groupId + "</groupId>\n" + "<artifactId>" + artifactId + "</artifactId>\n" + "<version></version>";
                context.getDocument().replaceString(startOffset, context.getSelectionEndOffset(), (CharSequence)value);
                context.getEditor().getCaretModel().moveToOffset(startOffset + value.length() - 10);
                shouldInvokeCompletion = true;
            } else {
                String classifier;
                StringBuilder sb = new StringBuilder();
                sb.append("<groupId>").append(groupId).append("</groupId>\n").append("<artifactId>").append(artifactId).append("</artifactId>\n");
                String type = managedDependency.getType().getRawText();
                if (type != null && !type.equals("jar")) {
                    sb.append("<type>").append(type).append("</type>\n");
                }
                if (StringUtil.isNotEmpty((String)(classifier = managedDependency.getClassifier().getRawText()))) {
                    sb.append("<classifier>").append(classifier).append("</classifier>\n");
                }
                context.getDocument().replaceString(startOffset, context.getSelectionEndOffset(), (CharSequence)sb);
            }
            context.commitDocument();
            for (e = psiFile.findElementAt(startOffset); !(e == null || e instanceof XmlTag && "dependency".equals(((XmlTag)e).getName())); e = e.getParent()) {
            }
            if (e != null) {
                new ReformatCodeProcessor(psiFile.getProject(), psiFile, e.getTextRange(), true).run();
            }
            if (shouldInvokeCompletion) {
                MavenDependencyCompletionUtil.invokeCompletion(context, CompletionType.BASIC);
            }
        }
    }
}

