/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.MavenGenerateDomElementProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class MavenGenerateTemplateAction
extends GenerateDomElementAction {
    public MavenGenerateTemplateAction(@NotNull String description, @NotNull Class<? extends DomElement> childElementClass, @Nullable String mappingId, @NotNull Function<MavenDomProjectModel, DomElement> parentFunction) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/generate/MavenGenerateTemplateAction", "<init>"));
        }
        if (childElementClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/generate/MavenGenerateTemplateAction", "<init>"));
        }
        if (parentFunction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/maven/dom/generate/MavenGenerateTemplateAction", "<init>"));
        }
        super((GenerateDomElementProvider)new MavenGenerateDomElementProvider(description, childElementClass, mappingId, parentFunction));
        this.getTemplatePresentation().setIcon(ElementPresentationManager.getIconForClass(childElementClass));
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/generate/MavenGenerateTemplateAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/generate/MavenGenerateTemplateAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/dom/generate/MavenGenerateTemplateAction", "isValidForFile"));
        }
        return file instanceof XmlFile && MavenDomUtil.getMavenDomModel(file, MavenDomProjectModel.class) != null;
    }
}

