/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.code;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;

public class MavenTypedHandlerDelegate
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/maven/dom/code/MavenTypedHandlerDelegate", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/maven/dom/code/MavenTypedHandlerDelegate", "charTyped"));
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c != '{') {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!MavenTypedHandlerDelegate.shouldProcess(file)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int offset = editor.getCaretModel().getOffset();
        if (MavenTypedHandlerDelegate.shouldCloseBrace(editor, offset, c)) {
            editor.getDocument().insertString(offset, (CharSequence)"}");
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean shouldCloseBrace(Editor editor, int offset, char c) {
        CharSequence text = editor.getDocument().getCharsSequence();
        if (offset < 2) {
            return false;
        }
        if (c != '{' || text.charAt(offset - 2) != '$') {
            return false;
        }
        if (offset < text.length()) {
            char next = text.charAt(offset);
            if (next == '}') {
                return false;
            }
            if (Character.isLetterOrDigit(next)) {
                return false;
            }
        }
        return true;
    }

    public static boolean shouldProcess(PsiFile file) {
        return MavenDomUtil.isMavenFile(file) || MavenDomUtil.isFilteredResourceFile((PsiElement)file);
    }
}

