/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.annotator;

import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import icons.MavenIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenDomGutterAnnotator
implements Annotator {
    private static void annotateDependencyUsages(@NotNull MavenDomDependency dependency, AnnotationHolder holder) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "annotateDependencyUsages"));
        }
        XmlTag tag = dependency.getXmlTag();
        if (tag == null) {
            return;
        }
        Set<MavenDomDependency> children = MavenDomProjectProcessorUtils.searchDependencyUsages(dependency);
        if (children.size() > 0) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.General.OverridenMethod, (NotNullFunction)DependencyConverter.INSTANCE);
            iconBuilder.setTargets(children).setPopupTitle(MavenDomBundle.message("navigate.parent.dependency.title", new Object[0])).setCellRenderer((PsiElementListCellRenderer)MyListCellRenderer.INSTANCE).setTooltipText(MavenDomBundle.message("overriding.dependency.title", new Object[0])).install(holder, (PsiElement)dependency.getXmlTag());
        }
    }

    private static void annotateManagedDependency(MavenDomDependency dependency, AnnotationHolder holder) {
        XmlTag tag = dependency.getXmlTag();
        if (tag == null) {
            return;
        }
        MavenDomDependency managingDependency = MavenDomGutterAnnotator.getManagingDependency(dependency);
        if (managingDependency != null) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.General.OverridingMethod, (NotNullFunction)DependencyConverter.INSTANCE);
            iconBuilder.setTargets((Object[])new MavenDomDependency[]{managingDependency}).setTooltipText(MavenDomGutterAnnotator.generateTooltip(managingDependency)).install(holder, (PsiElement)tag);
        }
    }

    @Nullable
    private static MavenDomDependency getManagingDependency(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "getManagingDependency"));
        }
        Project project = dependency.getManager().getProject();
        return MavenDomProjectProcessorUtils.searchManagingDependency(dependency, project);
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "annotate"));
        }
        if (psiElement instanceof XmlTag) {
            DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement((XmlTag)psiElement);
            if (element instanceof MavenDomDependency) {
                if (element.getParentOfType(MavenDomPlugin.class, true) != null) {
                    return;
                }
                MavenDomDependency dependency = (MavenDomDependency)element;
                if (MavenDomGutterAnnotator.isDependencyManagementSection(dependency)) {
                    MavenDomGutterAnnotator.annotateDependencyUsages(dependency, holder);
                } else {
                    MavenDomGutterAnnotator.annotateManagedDependency(dependency, holder);
                }
            } else if (element instanceof MavenDomParent) {
                MavenDomGutterAnnotator.annotateMavenDomParent((MavenDomParent)element, holder);
            } else if (element instanceof MavenDomProjectModel) {
                MavenDomGutterAnnotator.annotateMavenDomProjectChildren((MavenDomProjectModel)element, holder);
            } else if (element instanceof MavenDomPlugin) {
                MavenDomGutterAnnotator.annotateMavenDomPlugin((MavenDomPlugin)element, holder);
            }
        }
    }

    private static void annotateMavenDomPlugin(@NotNull MavenDomPlugin plugin, @NotNull AnnotationHolder holder) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "annotateMavenDomPlugin"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "annotateMavenDomPlugin"));
        }
        XmlTag xmlTag = plugin.getArtifactId().getXmlTag();
        if (xmlTag == null) {
            return;
        }
        DomElement plugins = plugin.getParent();
        if (plugins == null) {
            return;
        }
        DomElement parent = plugins.getParent();
        if (parent instanceof MavenDomPluginManagement) {
            MavenDomGutterAnnotator.annotateMavenDomPluginInManagement(plugin, holder);
            return;
        }
        MavenDomPlugin managingPlugin = MavenDomProjectProcessorUtils.searchManagingPlugin(plugin);
        if (managingPlugin != null) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.General.OverridingMethod, (NotNullFunction)PluginConverter.INSTANCE);
            iconBuilder.setTargets(Collections.singletonList(managingPlugin)).setTooltipText(MavenDomBundle.message("overriden.plugin.title", new Object[0])).install(holder, (PsiElement)xmlTag);
        }
    }

    private static void annotateMavenDomPluginInManagement(@NotNull MavenDomPlugin plugin, @NotNull AnnotationHolder holder) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "annotateMavenDomPluginInManagement"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "annotateMavenDomPluginInManagement"));
        }
        XmlTag xmlTag = plugin.getArtifactId().getXmlTag();
        if (xmlTag == null) {
            return;
        }
        Collection<MavenDomPlugin> children = MavenDomProjectProcessorUtils.searchManagedPluginUsages(plugin);
        if (children.size() > 0) {
            NavigationGutterIconBuilder iconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.General.OverridenMethod, (NotNullFunction)PluginConverter.INSTANCE);
            iconBuilder.setTargets(children).setPopupTitle(MavenDomBundle.message("navigate.parent.plugin.title", new Object[0])).setCellRenderer((PsiElementListCellRenderer)MyListCellRenderer.INSTANCE).setTooltipText(MavenDomBundle.message("overriding.plugin.title", new Object[0])).install(holder, (PsiElement)xmlTag);
        }
    }

    private static void annotateMavenDomParent(@NotNull MavenDomParent mavenDomParent, @NotNull AnnotationHolder holder) {
        if (mavenDomParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "annotateMavenDomParent"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "annotateMavenDomParent"));
        }
        MavenDomProjectModel parent = MavenDomProjectProcessorUtils.findParent(mavenDomParent, mavenDomParent.getManager().getProject());
        if (parent != null) {
            NavigationGutterIconBuilder.create((Icon)MavenIcons.ParentProject, (NotNullFunction)MavenProjectConverter.INSTANCE).setTargets((Object[])new MavenDomProjectModel[]{parent}).setTooltipText(MavenDomBundle.message("parent.pom.title", new Object[0])).install(holder, (PsiElement)mavenDomParent.getXmlElement());
        }
    }

    private static void annotateMavenDomProjectChildren(MavenDomProjectModel model, AnnotationHolder holder) {
        Set<MavenDomProjectModel> children;
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null && (children = MavenDomProjectProcessorUtils.getChildrenProjects(model)).size() > 0) {
            NavigationGutterIconBuilder.create((Icon)MavenIcons.ChildrenProjects, (NotNullFunction)MavenProjectConverter.INSTANCE).setTargets(children).setCellRenderer((PsiElementListCellRenderer)MyListCellRenderer.INSTANCE).setPopupTitle(MavenDomBundle.message("navigate.children.poms.title", new Object[0])).setTooltipText(MavenDomBundle.message("children.poms.title", new Object[0])).install(holder, (PsiElement)model.getXmlElement());
        }
    }

    private static boolean isDependencyManagementSection(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator", "isDependencyManagementSection"));
        }
        return dependency.getParentOfType(MavenDomDependencyManagement.class, false) != null;
    }

    private static String generateTooltip(MavenDomDependency dependency) {
        StringBuilder res = new StringBuilder();
        res.append("&lt;dependency&gt;\n");
        res.append("&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;").append(dependency.getGroupId().getStringValue()).append("&lt;/groupId&gt;\n");
        res.append("&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;").append(dependency.getArtifactId().getStringValue()).append("&lt;/artifactId&gt;\n");
        if (dependency.getType().getXmlElement() != null) {
            res.append("&nbsp;&nbsp;&nbsp;&nbsp;&lt;type&gt;").append(dependency.getType().getStringValue()).append("&lt;/type&gt;\n");
        }
        if (dependency.getClassifier().getXmlElement() != null) {
            res.append("&nbsp;&nbsp;&nbsp;&nbsp;&lt;classifier&gt;").append(dependency.getClassifier().getStringValue()).append("&lt;/classifier&gt;\n");
        }
        if (dependency.getScope().getXmlElement() != null) {
            res.append("&nbsp;&nbsp;&nbsp;&nbsp;&lt;scope&gt;").append(dependency.getScope().getStringValue()).append("&lt;/scope&gt;\n");
        }
        if (dependency.getOptional().getXmlElement() != null) {
            res.append("&nbsp;&nbsp;&nbsp;&nbsp;&lt;optional&gt;").append(dependency.getOptional().getStringValue()).append("&lt;/optional&gt;\n");
        }
        if (dependency.getVersion().getXmlElement() != null) {
            res.append("&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;").append(dependency.getVersion().getStringValue()).append("&lt;/version&gt;\n");
        }
        res.append("&lt;/dependency&gt;");
        return res.toString();
    }

    private static class MavenProjectConverter
    implements NotNullFunction<MavenDomProjectModel, Collection<? extends PsiElement>> {
        public static final MavenProjectConverter INSTANCE = new MavenProjectConverter();

        private MavenProjectConverter() {
        }

        @NotNull
        public Collection<? extends PsiElement> fun(MavenDomProjectModel pointer) {
            List list = ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$MavenProjectConverter", "fun"));
            }
            return list;
        }
    }

    private static class PluginConverter
    implements NotNullFunction<MavenDomPlugin, Collection<? extends PsiElement>> {
        public static final PluginConverter INSTANCE = new PluginConverter();

        private PluginConverter() {
        }

        @NotNull
        public Collection<? extends PsiElement> fun(MavenDomPlugin pointer) {
            List list = ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$PluginConverter", "fun"));
            }
            return list;
        }
    }

    private static class DependencyConverter
    implements NotNullFunction<MavenDomDependency, Collection<? extends PsiElement>> {
        public static final DependencyConverter INSTANCE = new DependencyConverter();

        private DependencyConverter() {
        }

        @NotNull
        public Collection<? extends PsiElement> fun(MavenDomDependency pointer) {
            List list = ContainerUtil.createMaybeSingletonList((Object)pointer.getXmlTag());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/annotator/MavenDomGutterAnnotator$DependencyConverter", "fun"));
            }
            return list;
        }
    }

    private static class MyListCellRenderer
    extends PsiElementListCellRenderer<XmlTag> {
        public static final MyListCellRenderer INSTANCE = new MyListCellRenderer();

        private MyListCellRenderer() {
        }

        public String getElementText(XmlTag tag) {
            MavenDomProjectModel model;
            DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (domElement != null && (model = (MavenDomProjectModel)domElement.getParentOfType(MavenDomProjectModel.class, false)) != null) {
                MavenProject mavenProject = MavenDomUtil.findProject(model);
                if (mavenProject != null) {
                    return mavenProject.getDisplayName();
                }
                String name = model.getName().getStringValue();
                if (!StringUtil.isEmptyOrSpaces((String)name)) {
                    return name;
                }
            }
            return tag.getContainingFile().getName();
        }

        protected String getContainerText(XmlTag element, String name) {
            return null;
        }

        protected Icon getIcon(PsiElement element) {
            return MavenIcons.MavenProject;
        }

        protected int getIconFlags() {
            return 0;
        }
    }
}

