/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class MavenSchemaProvider
implements StandardResourceProvider {
    public static final String MAVEN_PROJECT_SCHEMA_URL = "http://maven.apache.org/xsd/maven-4.0.0.xsd";
    public static final String MAVEN_PROFILES_SCHEMA_URL = "http://maven.apache.org/xsd/profiles-1.0.0.xsd";
    public static final String MAVEN_SETTINGS_SCHEMA_URL = "http://maven.apache.org/xsd/settings-1.0.0.xsd";

    public void registerResources(ResourceRegistrar registrar) {
        registrar.addStdResource("http://maven.apache.org/maven-v4_0_0.xsd", "/schemas/maven-4.0.0.xsd", this.getClass());
        registrar.addStdResource(MAVEN_PROJECT_SCHEMA_URL, "/schemas/maven-4.0.0.xsd", this.getClass());
        registrar.addStdResource(MAVEN_PROFILES_SCHEMA_URL, "/schemas/profiles-1.0.0.xsd", this.getClass());
        registrar.addStdResource(MAVEN_SETTINGS_SCHEMA_URL, "/schemas/settings-1.0.0.xsd", this.getClass());
    }

    @NotNull
    public static VirtualFile getSchemaFile(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/MavenSchemaProvider", "getSchemaFile"));
        }
        String location = ((ExternalResourceManagerEx)ExternalResourceManager.getInstance()).getStdResource(url, null);
        assert (location != null) : "cannot find a standard resource for " + url;
        VirtualFile result = VfsUtil.findRelativeFile((String)location, null);
        assert (result != null) : "cannot find a schema file for URL: " + url + " location: " + location;
        VirtualFile virtualFile = result;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenSchemaProvider", "getSchemaFile"));
        }
        return virtualFile;
    }
}

