/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.maven.compiler.MavenEscapeWindowsCharacterUtils;

public class MavenPropertyResolver {
    public static final Pattern PATTERN = Pattern.compile("\\$\\{(.+?)\\}|@(.+?)@");

    public static void doFilterText(Module module, String text, Properties additionalProperties, @Nullable String propertyEscapeString, Appendable out) throws IOException {
        MavenProjectsManager manager = MavenProjectsManager.getInstance(module.getProject());
        MavenProject mavenProject = manager.findProject(module);
        if (mavenProject == null) {
            out.append(text);
            return;
        }
        Element pluginConfiguration = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        String escapeWindowsPathsStr = MavenJDOMUtil.findChildValueByPath(pluginConfiguration, "escapeWindowsPaths");
        boolean escapeWindowsPath = escapeWindowsPathsStr == null || Boolean.parseBoolean(escapeWindowsPathsStr);
        MavenPropertyResolver.doFilterText(MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject), manager, mavenProject, text, additionalProperties, propertyEscapeString, escapeWindowsPath, null, out);
    }

    private static void doFilterText(Pattern pattern, MavenProjectsManager mavenProjectsManager, MavenProject mavenProject, String text, Properties additionalProperties, @Nullable String escapeString, boolean escapeWindowsPath, @Nullable Map<String, String> resolvedPropertiesParam, Appendable out) throws IOException {
        Map<String, String> resolvedProperties = resolvedPropertiesParam;
        Matcher matcher = pattern.matcher(text);
        int groupCount = matcher.groupCount();
        int last = 0;
        while (matcher.find()) {
            String propertyValue;
            int escapeStringStartIndex;
            if (escapeString != null && (escapeStringStartIndex = matcher.start() - escapeString.length()) >= last && text.startsWith(escapeString, escapeStringStartIndex)) {
                out.append(text, last, escapeStringStartIndex);
                out.append(matcher.group());
                last = matcher.end();
                continue;
            }
            out.append(text, last, matcher.start());
            last = matcher.end();
            String propertyName = null;
            for (int i = 0; i < groupCount && (propertyName = matcher.group(i + 1)) == null; ++i) {
            }
            assert (propertyName != null);
            if (resolvedProperties == null) {
                resolvedProperties = new HashMap<String, String>();
            }
            if ((propertyValue = resolvedProperties.get(propertyName)) == null) {
                if (resolvedProperties.containsKey(propertyName)) {
                    out.append(matcher.group());
                    continue;
                }
                String resolved = MavenPropertyResolver.doResolveProperty(propertyName, mavenProjectsManager, mavenProject, additionalProperties);
                if (resolved == null) {
                    out.append(matcher.group());
                    continue;
                }
                resolvedProperties.put(propertyName, null);
                StringBuilder sb = new StringBuilder();
                MavenPropertyResolver.doFilterText(pattern, mavenProjectsManager, mavenProject, resolved, additionalProperties, null, escapeWindowsPath, resolvedProperties, sb);
                propertyValue = sb.toString();
                resolvedProperties.put(propertyName, propertyValue);
            }
            if (escapeWindowsPath) {
                MavenEscapeWindowsCharacterUtils.escapeWindowsPath((Appendable)out, (String)propertyValue);
                continue;
            }
            out.append(propertyValue);
        }
        out.append(text, last, text.length());
    }

    public static String resolve(String text, MavenDomProjectModel projectDom) {
        XmlElement element = projectDom.getXmlElement();
        if (element == null) {
            return text;
        }
        VirtualFile file = MavenDomUtil.getVirtualFile((PsiElement)element);
        if (file == null) {
            return text;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(projectDom.getManager().getProject());
        MavenProject mavenProject = manager.findProject(file);
        if (mavenProject == null) {
            return text;
        }
        StringBuilder res = new StringBuilder();
        try {
            MavenPropertyResolver.doFilterText(PATTERN, manager, mavenProject, text, MavenPropertyResolver.collectPropertiesFromDOM(mavenProject, projectDom), null, false, null, res);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return res.toString();
    }

    private static Properties collectPropertiesFromDOM(MavenProject project, MavenDomProjectModel projectDom) {
        Properties result = new Properties();
        MavenPropertyResolver.collectPropertiesFromDOM(projectDom.getProperties(), result);
        Collection<String> activePropfiles = project.getActivatedProfilesIds();
        for (MavenDomProfile each : projectDom.getProfiles().getProfiles()) {
            XmlTag idTag = each.getId().getXmlTag();
            if (idTag == null || !activePropfiles.contains(idTag.getValue().getTrimmedText())) continue;
            MavenPropertyResolver.collectPropertiesFromDOM(each.getProperties(), result);
        }
        return result;
    }

    private static void collectPropertiesFromDOM(MavenDomProperties props, Properties result) {
        XmlTag propsTag = props.getXmlTag();
        if (propsTag != null) {
            for (XmlTag each : propsTag.getSubTags()) {
                result.setProperty(each.getName(), each.getValue().getTrimmedText());
            }
        }
    }

    @Nullable
    private static String doResolveProperty(String propName, MavenProjectsManager projectsManager, MavenProject mavenProject, Properties additionalProperties) {
        String javaVersion;
        String jreDir;
        boolean hasPrefix = false;
        String unprefixed = propName;
        if (propName.startsWith("pom.")) {
            unprefixed = propName.substring("pom.".length());
            hasPrefix = true;
        } else if (propName.startsWith("project.")) {
            unprefixed = propName.substring("project.".length());
            hasPrefix = true;
        }
        MavenProject selectedProject = mavenProject;
        while (unprefixed.startsWith("parent.")) {
            MavenId parentId = selectedProject.getParentId();
            if (parentId == null) {
                return null;
            }
            if ((unprefixed = unprefixed.substring("parent.".length())).equals("groupId")) {
                return parentId.getGroupId();
            }
            if (unprefixed.equals("artifactId")) {
                return parentId.getArtifactId();
            }
            if (unprefixed.equals("version")) {
                return parentId.getVersion();
            }
            selectedProject = projectsManager.findProject(parentId);
            if (selectedProject != null) continue;
            return null;
        }
        if (unprefixed.equals("basedir") || hasPrefix && mavenProject == selectedProject && unprefixed.equals("baseUri")) {
            return selectedProject.getDirectory();
        }
        if ("java.home".equals(propName) && (jreDir = MavenUtil.getModuleJreHome(projectsManager, mavenProject)) != null) {
            return jreDir;
        }
        if ("java.version".equals(propName) && (javaVersion = MavenUtil.getModuleJavaVersion(projectsManager, mavenProject)) != null) {
            return javaVersion;
        }
        String result = MavenUtil.getPropertiesFromMavenOpts().get(propName);
        if (result != null) {
            return result;
        }
        result = MavenServerUtil.collectSystemProperties().getProperty(propName);
        if (result != null) {
            return result;
        }
        result = selectedProject.getModelMap().get(unprefixed);
        if (result != null) {
            return result;
        }
        result = additionalProperties.getProperty(propName);
        if (result != null) {
            return result;
        }
        result = mavenProject.getProperties().getProperty(propName);
        if (result != null) {
            return result;
        }
        if ("settings.localRepository".equals(propName)) {
            return mavenProject.getLocalRepository().getAbsolutePath();
        }
        return null;
    }
}

