/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import gnu.trove.THashMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDomConvertersRegistry;
import org.jetbrains.idea.maven.dom.converters.MavenPluginCustomParameterValueConverter;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomConfigurationParameter;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.plugin.MavenDomMojo;
import org.jetbrains.idea.maven.dom.plugin.MavenDomParameter;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;

public class MavenPluginConfigurationDomExtender
extends DomExtender<MavenDomConfiguration> {
    public static final Key<ParameterData> PLUGIN_PARAMETER_KEY = Key.create((String)"MavenPluginConfigurationDomExtender.PLUGIN_PARAMETER_KEY");
    private static final Set<String> COLLECTIONS_TYPE_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"java.util.Collection", "java.util.Set", "java.util.List", "java.util.ArrayList", "java.util.HashSet", "java.util.LinkedList"});

    public void registerExtensions(@NotNull MavenDomConfiguration config, @NotNull DomExtensionsRegistrar r) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender", "registerExtensions"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender", "registerExtensions"));
        }
        MavenDomPluginModel pluginModel = MavenPluginDomUtil.getMavenPluginModel(config);
        if (pluginModel == null) {
            r.registerCustomChildrenExtension(MavenDomConfigurationParameter.class);
            return;
        }
        boolean isInPluginManagement = MavenPluginConfigurationDomExtender.isInPluginManagement(config);
        for (ParameterData each : MavenPluginConfigurationDomExtender.collectParameters(pluginModel, config)) {
            MavenPluginConfigurationDomExtender.registerPluginParameter(isInPluginManagement, r, each);
        }
    }

    private static boolean isInPluginManagement(MavenDomConfiguration pluginNode) {
        XmlElement xmlElement = pluginNode.getXmlElement();
        if (xmlElement == null) {
            return false;
        }
        PsiElement pluginTag = xmlElement.getParent();
        if (pluginTag == null) {
            return false;
        }
        PsiElement pluginsTag = pluginTag.getParent();
        if (pluginsTag == null) {
            return false;
        }
        PsiElement pluginManagementTag = pluginsTag.getParent();
        return pluginManagementTag instanceof XmlTag && "pluginManagement".equals(((XmlTag)pluginManagementTag).getName());
    }

    private static Collection<ParameterData> collectParameters(MavenDomPluginModel pluginModel, MavenDomConfiguration config) {
        ArrayList<String> selectedGoals = null;
        MavenDomPluginExecution executionElement = (MavenDomPluginExecution)config.getParentOfType(MavenDomPluginExecution.class, false);
        if (executionElement != null) {
            String goal;
            selectedGoals = new ArrayList<String>();
            String id = executionElement.getId().getStringValue();
            String defaultPrefix = "default-";
            if (id != null && id.startsWith(defaultPrefix) && !StringUtil.isEmptyOrSpaces((String)(goal = id.substring(defaultPrefix.length())))) {
                selectedGoals.add(goal);
            }
            for (MavenDomGoal mavenDomGoal : executionElement.getGoals().getGoals()) {
                selectedGoals.add(mavenDomGoal.getStringValue());
            }
        }
        THashMap namesWithParameters = new THashMap();
        for (MavenDomMojo eachMojo : pluginModel.getMojos().getMojos()) {
            String string = eachMojo.getGoal().getStringValue();
            if (string == null || selectedGoals != null && !selectedGoals.contains(string)) continue;
            for (MavenDomParameter eachParameter : eachMojo.getParameters().getParameters()) {
                String name;
                if (eachParameter.getEditable().getValue() == Boolean.FALSE || (name = eachParameter.getName().getStringValue()) == null) continue;
                ParameterData data = new ParameterData(eachParameter);
                MavenPluginConfigurationDomExtender.fillParameterData(name, data, eachMojo);
                ParameterData oldParameter = (ParameterData)namesWithParameters.get(name);
                if (oldParameter != null && !MavenPluginConfigurationDomExtender.hasMorePriority(data, oldParameter, executionElement != null)) continue;
                namesWithParameters.put(name, data);
            }
        }
        return namesWithParameters.values();
    }

    private static boolean hasMorePriority(ParameterData d1, ParameterData d2, boolean isForExecutionSection) {
        if (!isForExecutionSection) {
            if (StringUtil.isEmptyOrSpaces((String)d1.getMojo().getPhase().getStringValue())) {
                return false;
            }
            if (StringUtil.isEmptyOrSpaces((String)d2.getMojo().getPhase().getStringValue())) {
                return true;
            }
        }
        return d1.getRequiringLevel() > d2.getRequiringLevel();
    }

    private static void fillParameterData(String name, ParameterData data, MavenDomMojo mojo) {
        XmlTag config = mojo.getConfiguration().getXmlTag();
        if (config == null) {
            return;
        }
        for (XmlTag each : config.getSubTags()) {
            if (!name.equals(each.getName())) continue;
            data.defaultValue = each.getAttributeValue("default-value");
            data.expression = each.getValue().getTrimmedText();
        }
    }

    private static void registerPluginParameter(boolean isInPluginManagement, DomExtensionsRegistrar r, ParameterData parameter) {
        String paramName = parameter.parameter.getName().getStringValue();
        String alias = parameter.parameter.getAlias().getStringValue();
        MavenPluginConfigurationDomExtender.registerPluginParameter(isInPluginManagement, r, parameter, paramName);
        if (alias != null) {
            MavenPluginConfigurationDomExtender.registerPluginParameter(isInPluginManagement, r, parameter, alias);
        }
    }

    private static void registerPluginParameter(boolean isInPluginManagement, DomExtensionsRegistrar r, final ParameterData data, final String parameterName) {
        DomExtension e = r.registerFixedNumberChildExtension(new XmlName(parameterName), MavenDomConfigurationParameter.class);
        if (MavenPluginConfigurationDomExtender.isCollection(data.parameter)) {
            e.addExtender(new DomExtender(){

                public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                    if (domElement == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender$1", "registerExtensions"));
                    }
                    if (registrar == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender$1", "registerExtensions"));
                    }
                    for (String each : MavenPluginConfigurationDomExtender.collectPossibleNameForCollectionParameter(parameterName)) {
                        DomExtension inner = registrar.registerCollectionChildrenExtension(new XmlName(each), MavenDomConfigurationParameter.class);
                        inner.setDeclaringElement((DomElement)data.parameter);
                    }
                }
            });
        } else {
            MavenPluginConfigurationDomExtender.addValueConverter(e, data.parameter);
            if (!isInPluginManagement) {
                MavenPluginConfigurationDomExtender.addRequiredAnnotation(e, data);
            }
        }
        e.setDeclaringElement((DomElement)data.parameter);
        data.parameter.getXmlElement().putUserData(PLUGIN_PARAMETER_KEY, (Object)data);
    }

    private static void addValueConverter(DomExtension e, MavenDomParameter parameter) {
        String type = parameter.getType().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)type)) {
            e.setConverter((Converter)new MavenPluginCustomParameterValueConverter(type), MavenDomConvertersRegistry.getInstance().isSoft(type));
        }
    }

    private static void addRequiredAnnotation(DomExtension e, ParameterData data) {
        if (Boolean.parseBoolean(data.parameter.getRequired().getStringValue()) && StringUtil.isEmptyOrSpaces((String)data.defaultValue) && StringUtil.isEmptyOrSpaces((String)data.expression)) {
            e.addCustomAnnotation((Annotation)new Required(){

                public boolean value() {
                    return true;
                }

                public boolean nonEmpty() {
                    return false;
                }

                public boolean identifier() {
                    return false;
                }

                public Class<? extends Annotation> annotationType() {
                    return Required.class;
                }
            });
        }
    }

    public static List<String> collectPossibleNameForCollectionParameter(String parameterName) {
        String singularName = StringUtil.unpluralize((String)parameterName);
        if (singularName == null) {
            singularName = parameterName;
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] parts = NameUtil.splitNameIntoWords((String)singularName);
        for (int i = 0; i < parts.length; ++i) {
            result.add(StringUtil.decapitalize((String)StringUtil.join((String[])parts, (int)i, (int)parts.length, (String)"")));
        }
        return result;
    }

    private static boolean isCollection(MavenDomParameter parameter) {
        String type = parameter.getType().getStringValue();
        if (type == null) {
            return false;
        }
        return type.endsWith("[]") || COLLECTIONS_TYPE_NAMES.contains(type);
    }

    public static class ParameterData {
        public final MavenDomParameter parameter;
        @Nullable
        public String defaultValue;
        @Nullable
        public String expression;

        private ParameterData(MavenDomParameter parameter) {
            this.parameter = parameter;
        }

        @NotNull
        public MavenDomMojo getMojo() {
            MavenDomMojo mavenDomMojo = (MavenDomMojo)this.parameter.getParent().getParent();
            if (mavenDomMojo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender$ParameterData", "getMojo"));
            }
            return mavenDomMojo;
        }

        public int getRequiringLevel() {
            if (!Boolean.parseBoolean(this.parameter.getRequired().getStringValue())) {
                return 0;
            }
            if (!StringUtil.isEmptyOrSpaces((String)this.defaultValue) || !StringUtil.isEmptyOrSpaces((String)this.expression)) {
                return 1;
            }
            return 2;
        }
    }
}

