/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.compiler;

import com.intellij.compiler.CompilerIOUtil;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenResourceCompiler
implements ClassPostProcessingCompiler {
    private static final Key<List<String>> FILES_TO_DELETE_KEY = Key.create((String)(MavenResourceCompiler.class.getSimpleName() + ".FILES_TO_DELETE"));
    private static final Set<String> DEFAULT_NON_FILTERED_EXTENSIONS = ContainerUtil.newHashSet((Object[])new String[]{"jpg", "jpeg", "gif", "bmp", "png"});
    private Map<String, Set<String>> myOutputItemsCache = new THashMap();

    public MavenResourceCompiler(Project project) {
        this.loadCache(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache(Project project) {
        File file = MavenResourceCompiler.getCacheFile(project);
        if (!file.exists()) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            try {
                if (in.readInt() != 55) {
                    return;
                }
                int modulesSize = in.readInt();
                THashMap temp = new THashMap();
                while (modulesSize-- > 0) {
                    String module = CompilerIOUtil.readString((DataInput)in);
                    int pathsSize = in.readInt();
                    Set<String> paths = MavenResourceCompiler.createPathsSet();
                    while (pathsSize-- > 0) {
                        paths.add(CompilerIOUtil.readString((DataInput)in));
                    }
                    temp.put(module, paths);
                }
                this.myOutputItemsCache = temp;
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    private static Set<String> createPathsSet() {
        return new THashSet(FileUtil.PATH_HASHING_STRATEGY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCache(Project project) {
        File file = MavenResourceCompiler.getCacheFile(project);
        file.getParentFile().mkdirs();
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeInt(55);
                out.writeInt(this.myOutputItemsCache.size());
                for (Map.Entry<String, Set<String>> eachEntry : this.myOutputItemsCache.entrySet()) {
                    String module = eachEntry.getKey();
                    Set<String> paths = eachEntry.getValue();
                    CompilerIOUtil.writeString((String)module, (DataOutput)out);
                    out.writeInt(paths.size());
                    for (String eachPath : paths) {
                        CompilerIOUtil.writeString((String)eachPath, (DataOutput)out);
                    }
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            MavenLog.LOG.error((Throwable)e);
        }
    }

    private static File getCacheFile(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory((Project)project), "maven_compiler_caches.dat");
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext context) {
        Project project = context.getProject();
        MavenProjectsManager mavenProjectManager = MavenProjectsManager.getInstance(project);
        if (!mavenProjectManager.isMavenizedProject()) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/compiler/MavenResourceCompiler", "getProcessingItems"));
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        ArrayList<Object> allItemsToProcess = new ArrayList<Object>();
        ArrayList<String> filesToDelete = new ArrayList<String>();
        Date timestamp = new Date();
        AccessToken accessToken = ReadAction.start();
        try {
            for (Module eachModule : context.getCompileScope().getAffectedModules()) {
                MavenProject mavenProject = mavenProjectManager.findProject(eachModule);
                if (mavenProject == null) continue;
                Properties properties = MavenResourceCompiler.loadPropertiesAndFilters(context, mavenProject);
                long propertiesHashCode = MavenResourceCompiler.calculateHashCode(mavenProject, properties);
                String timestampFormat = properties.getProperty("maven.build.timestamp.format");
                if (timestampFormat == null) {
                    timestampFormat = "yyyyMMdd-HHmm";
                }
                String timestampString = new SimpleDateFormat(timestampFormat).format(timestamp);
                properties.setProperty("maven.build.timestamp", timestampString);
                Set<String> nonFilteredExtensions = MavenResourceCompiler.collectNonFilteredExtensions(mavenProject);
                String escapeString = MavenJDOMUtil.findChildValueByPath(mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin"), "escapeString", null);
                ArrayList<MyProcessingItem> moduleItemsToProcess = new ArrayList<MyProcessingItem>();
                MavenResourceCompiler.collectProcessingItems(eachModule, mavenProject, context, properties, propertiesHashCode, nonFilteredExtensions, escapeString, false, moduleItemsToProcess);
                MavenResourceCompiler.collectProcessingItems(eachModule, mavenProject, context, properties, propertiesHashCode, nonFilteredExtensions, escapeString, true, moduleItemsToProcess);
                this.collectItemsToDelete(eachModule, moduleItemsToProcess, filesToDelete);
                allItemsToProcess.addAll(moduleItemsToProcess);
            }
            if (!filesToDelete.isEmpty()) {
                allItemsToProcess.add(new FakeProcessingItem());
            }
            context.putUserData(FILES_TO_DELETE_KEY, filesToDelete);
            this.removeObsoleteModulesFromCache(project);
            this.saveCache(project);
        }
        finally {
            accessToken.finish();
        }
        FileProcessingCompiler.ProcessingItem[] processingItemArray = allItemsToProcess.toArray(new FileProcessingCompiler.ProcessingItem[allItemsToProcess.size()]);
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/compiler/MavenResourceCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    private static Set<String> collectNonFilteredExtensions(MavenProject mavenProject) {
        Element config = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (config == null) {
            return DEFAULT_NON_FILTERED_EXTENSIONS;
        }
        List<String> customNonFilteredExtensions = MavenJDOMUtil.findChildrenValuesByPath(config, "nonFilteredFileExtensions", "nonFilteredFileExtension");
        if (customNonFilteredExtensions.isEmpty()) {
            return DEFAULT_NON_FILTERED_EXTENSIONS;
        }
        HashSet<String> result = new HashSet<String>();
        result.addAll(DEFAULT_NON_FILTERED_EXTENSIONS);
        result.addAll(customNonFilteredExtensions);
        return result;
    }

    private static long calculateHashCode(MavenProject project, Properties properties) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> each : properties.entrySet()) {
            sorted.put(each.getKey().toString(), each.getValue().toString());
        }
        return project.getLastReadStamp() + (long)(31 * ((Object)sorted).hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesAndFilters(CompileContext context, MavenProject mavenProject) {
        Properties properties = new Properties();
        for (String each : mavenProject.getFilterPropertiesFiles()) {
            try {
                FileInputStream in = new FileInputStream(each);
                try {
                    properties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                String url = VfsUtil.pathToUrl((String)mavenProject.getFile().getPath());
                context.addMessage(CompilerMessageCategory.WARNING, "Maven: Cannot read the filter. " + e.getMessage(), url, -1, -1);
            }
        }
        properties.putAll((Map<?, ?>)mavenProject.getProperties());
        return properties;
    }

    private static void collectProcessingItems(Module module, MavenProject mavenProject, CompileContext context, Properties properties, long propertiesHashCode, Set<String> nonFilteredExtensions, @Nullable String escapeString, boolean tests, List<MyProcessingItem> result) {
        String outputDir = CompilerPaths.getModuleOutputPath((Module)module, (boolean)tests);
        if (outputDir == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "Maven: Module '" + module.getName() + "'output is not specified", null, -1, -1);
            return;
        }
        List<MavenResource> resources = tests ? mavenProject.getTestResources() : mavenProject.getResources();
        for (MavenResource each : resources) {
            VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(each.getDirectory());
            if (dir == null) continue;
            List<Pattern> includes = MavenResourceCompiler.collectPatterns(each.getIncludes(), "**/*");
            List<Pattern> excludes = MavenResourceCompiler.collectPatterns(each.getExcludes(), null);
            String targetPath = each.getTargetPath();
            String resourceOutputDir = StringUtil.isEmptyOrSpaces((String)targetPath) ? outputDir : (FileUtil.isAbsolute((String)targetPath) ? targetPath : outputDir + "/" + targetPath);
            MavenResourceCompiler.collectProcessingItems(module, dir, dir, resourceOutputDir, includes, excludes, each.isFiltered(), properties, propertiesHashCode, nonFilteredExtensions, escapeString, result, context.getProgressIndicator());
        }
    }

    public static List<Pattern> collectPatterns(@Nullable List<String> values, @Nullable String defaultValue) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        if (values == null || values.isEmpty()) {
            if (defaultValue == null) {
                return Collections.emptyList();
            }
            return MavenUtil.collectPattern(defaultValue, result);
        }
        for (String each : values) {
            MavenUtil.collectPattern(each, result);
        }
        return result;
    }

    private static void collectProcessingItems(final Module module, final VirtualFile sourceRoot, VirtualFile currentDir, final String outputDir, final List<Pattern> includes, final List<Pattern> excludes, final boolean isSourceRootFiltered, final Properties properties, final long propertiesHashCode, final Set<String> nonFilteredExtensions, final @Nullable String escapeString, final List<MyProcessingItem> result, final ProgressIndicator indicator) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)currentDir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/maven/compiler/MavenResourceCompiler$1", "visitFile"));
                }
                indicator.checkCanceled();
                if (!file.isDirectory()) {
                    String relPath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot, (char)'/');
                    if (relPath == null) {
                        MavenLog.LOG.error("Cannot calculate relate path for file: " + file + " in root: " + sourceRoot);
                        return true;
                    }
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
                    if (fileIndex.isIgnored(file)) {
                        return true;
                    }
                    if (!MavenUtil.isIncluded(relPath, includes, excludes)) {
                        return true;
                    }
                    String outputPath = outputDir + "/" + relPath;
                    long outputFileTimestamp = -1L;
                    File outputFile = new File(outputPath);
                    if (outputFile.exists()) {
                        outputFileTimestamp = outputFile.lastModified();
                    }
                    boolean isFiltered = isSourceRootFiltered && !nonFilteredExtensions.contains(file.getExtension());
                    result.add(new MyProcessingItem(module, file, outputPath, outputFileTimestamp, isFiltered, properties, propertiesHashCode, escapeString));
                }
                return true;
            }
        });
    }

    private void collectItemsToDelete(Module module, List<MyProcessingItem> processingItems, List<String> result) {
        Set<String> currentPaths = MavenResourceCompiler.createPathsSet();
        for (MyProcessingItem each : processingItems) {
            currentPaths.add(each.getOutputPath());
        }
        Set<String> cachedPaths = this.myOutputItemsCache.put(module.getName(), currentPaths);
        if (cachedPaths != null) {
            for (Set<String> set : this.myOutputItemsCache.values()) {
                cachedPaths.removeAll(set);
            }
            result.addAll(cachedPaths);
        }
    }

    private void removeObsoleteModulesFromCache(Project project) {
        THashSet existingModules = new THashSet();
        for (Module each : ModuleManager.getInstance((Project)project).getModules()) {
            existingModules.add(each.getName());
        }
        for (String each : new THashSet(this.myOutputItemsCache.keySet())) {
            if (existingModules.contains(each)) continue;
            this.myOutputItemsCache.remove(each);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        context.getProgressIndicator().setText("Processing Maven resources...");
        ArrayList<MyProcessingItem> result = new ArrayList<MyProcessingItem>(items.length);
        ArrayList<File> filesToRefresh = new ArrayList<File>(items.length);
        MavenResourceCompiler.deleteOutdatedFile((List)context.getUserData(FILES_TO_DELETE_KEY), filesToRefresh);
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof MyProcessingItem)) continue;
            context.getProgressIndicator().setFraction((double)i / (double)items.length);
            context.getProgressIndicator().checkCanceled();
            MyProcessingItem eachItem = (MyProcessingItem)items[i];
            VirtualFile sourceVirtualFile = eachItem.getFile();
            File sourceFile = new File(sourceVirtualFile.getPath());
            File outputFile = new File(eachItem.getOutputPath());
            try {
                outputFile.getParentFile().mkdirs();
                boolean shouldFilter = eachItem.isFiltered();
                if (shouldFilter && sourceFile.length() > 0xA00000L) {
                    context.addMessage(CompilerMessageCategory.WARNING, "Maven: File is too big to be filtered. Most likely it is a binary file and should be excluded from filtering.", sourceVirtualFile.getUrl(), -1, -1);
                    shouldFilter = false;
                }
                if (shouldFilter) {
                    String charset = sourceVirtualFile.getCharset().name();
                    String text = new String(FileUtil.loadFileBytes((File)sourceFile), charset);
                    PrintWriter printWriter = new PrintWriter(outputFile, charset);
                    try {
                        MavenPropertyResolver.doFilterText(eachItem.getModule(), text, eachItem.getProperties(), eachItem.getEscapeString(), printWriter);
                    }
                    finally {
                        printWriter.close();
                    }
                } else {
                    FileUtil.copy((File)sourceFile, (File)outputFile);
                }
                eachItem.getValidityState().setOutputFileTimestamp(outputFile.lastModified());
                result.add(eachItem);
                filesToRefresh.add(outputFile);
                continue;
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
                context.addMessage(CompilerMessageCategory.ERROR, "Maven: Cannot process resource file: " + e.getMessage(), sourceVirtualFile.getUrl(), -1, -1);
            }
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
        return result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
    }

    private static void deleteOutdatedFile(List<String> filesToDelete, List<File> filesToRefresh) {
        for (String each : filesToDelete) {
            File file = new File(each);
            if (!FileUtil.delete((File)file)) continue;
            filesToRefresh.add(file);
        }
    }

    @NotNull
    public String getDescription() {
        if ("Maven Resource Compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/compiler/MavenResourceCompiler", "getDescription"));
        }
        return "Maven Resource Compiler";
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return MyValididtyState.load(in);
    }

    private static class MyValididtyState
    implements ValidityState {
        private final long mySourceFileTimestamp;
        private long myOutputFileTimestamp;
        private final boolean myFiltered;
        private final long myPropertiesHashCode;
        private final String myEscapeString;

        public static MyValididtyState load(DataInput in) throws IOException {
            return new MyValididtyState(in.readLong(), in.readLong(), in.readBoolean(), in.readLong(), in.readUTF());
        }

        public void setOutputFileTimestamp(long outputFileTimestamp) {
            this.myOutputFileTimestamp = outputFileTimestamp;
        }

        private MyValididtyState(long sourceFileTimestamp, long outputFileTimestamp, boolean isFiltered, long propertiesHashCode, String escapeString) {
            this.mySourceFileTimestamp = sourceFileTimestamp;
            this.myOutputFileTimestamp = outputFileTimestamp;
            this.myFiltered = isFiltered;
            if (isFiltered) {
                this.myPropertiesHashCode = propertiesHashCode;
                this.myEscapeString = escapeString;
            } else {
                this.myPropertiesHashCode = 0L;
                this.myEscapeString = "";
            }
        }

        public String toString() {
            return this.mySourceFileTimestamp + " " + this.myOutputFileTimestamp + " " + this.myFiltered + " " + this.myPropertiesHashCode + " " + this.myEscapeString;
        }

        public boolean equalsTo(ValidityState otherState) {
            if (!(otherState instanceof MyValididtyState)) {
                return false;
            }
            MyValididtyState that = (MyValididtyState)otherState;
            return this.mySourceFileTimestamp == that.mySourceFileTimestamp && this.myOutputFileTimestamp == that.myOutputFileTimestamp && this.myFiltered == that.myFiltered && this.myPropertiesHashCode == that.myPropertiesHashCode && Comparing.strEqual((String)this.myEscapeString, (String)that.myEscapeString);
        }

        public void save(DataOutput out) throws IOException {
            out.writeLong(this.mySourceFileTimestamp);
            out.writeLong(this.myOutputFileTimestamp);
            out.writeBoolean(this.myFiltered);
            out.writeLong(this.myPropertiesHashCode);
            out.writeUTF(this.myEscapeString);
        }
    }

    private static class FakeProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final LightVirtualFile myFile = new LightVirtualFile(this.getClass().getName());

        private FakeProcessingItem() {
        }

        @NotNull
        public VirtualFile getFile() {
            LightVirtualFile lightVirtualFile = this.myFile;
            if (lightVirtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/compiler/MavenResourceCompiler$FakeProcessingItem", "getFile"));
            }
            return lightVirtualFile;
        }

        public ValidityState getValidityState() {
            return null;
        }
    }

    private static class MyProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final Module myModule;
        private final VirtualFile mySourceFile;
        private final String myOutputPath;
        private final boolean myFiltered;
        private final Properties myProperties;
        private final String myEscapeString;
        private final MyValididtyState myState;

        public MyProcessingItem(Module module, VirtualFile sourceFile, String outputPath, long outputFileTimestamp, boolean isFiltered, Properties properties, long propertiesHashCode, @Nullable String escapeString) {
            this.myModule = module;
            this.mySourceFile = sourceFile;
            this.myOutputPath = outputPath;
            this.myFiltered = isFiltered;
            this.myProperties = properties;
            this.myEscapeString = escapeString;
            this.myState = new MyValididtyState(sourceFile.getTimeStamp(), outputFileTimestamp, isFiltered, propertiesHashCode, escapeString);
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.mySourceFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/compiler/MavenResourceCompiler$MyProcessingItem", "getFile"));
            }
            return virtualFile;
        }

        public String getOutputPath() {
            return this.myOutputPath;
        }

        public Module getModule() {
            return this.myModule;
        }

        public boolean isFiltered() {
            return this.myFiltered;
        }

        public Properties getProperties() {
            return this.myProperties;
        }

        @Nullable
        public String getEscapeString() {
            return this.myEscapeString;
        }

        @NotNull
        public MyValididtyState getValidityState() {
            MyValididtyState myValididtyState = this.myState;
            if (myValididtyState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/compiler/MavenResourceCompiler$MyProcessingItem", "getValidityState"));
            }
            return myValididtyState;
        }
    }
}

