/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Properties;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleLog;

public class GradleUtil {
    private static final String LAST_USED_GRADLE_HOME_KEY = "last.used.gradle.home";
    @NonNls
    private static final String JVM_ARG_FORMAT = "-D%1$s=%2$s";

    private GradleUtil() {
    }

    @NotNull
    public static FileChooserDescriptor getGradleProjectFileChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = DescriptorHolder.GRADLE_BUILD_FILE_CHOOSER_DESCRIPTOR;
        if (fileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/util/GradleUtil", "getGradleProjectFileChooserDescriptor"));
        }
        return fileChooserDescriptor;
    }

    @NotNull
    public static FileChooserDescriptor getGradleHomeFileChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = DescriptorHolder.GRADLE_HOME_FILE_CHOOSER_DESCRIPTOR;
        if (fileChooserDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/util/GradleUtil", "getGradleHomeFileChooserDescriptor"));
        }
        return fileChooserDescriptor;
    }

    public static boolean isGradleDefaultWrapperFilesExist(@Nullable String gradleProjectPath) {
        return GradleUtil.getWrapperConfiguration(gradleProjectPath) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static WrapperConfiguration getWrapperConfiguration(@Nullable String gradleProjectPath) {
        File wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(gradleProjectPath);
        if (wrapperPropertiesFile == null) {
            return null;
        }
        WrapperConfiguration wrapperConfiguration = new WrapperConfiguration();
        Properties props = new Properties();
        BufferedReader reader = null;
        try {
            String distPathBase;
            reader = new BufferedReader(new FileReader(wrapperPropertiesFile));
            props.load(reader);
            String distributionUrl = props.getProperty("distributionUrl");
            if (StringUtil.isEmpty((String)distributionUrl)) {
                throw new ExternalSystemException("Wrapper 'distributionUrl' property does not exist!");
            }
            wrapperConfiguration.setDistribution(new URI(distributionUrl));
            String distributionPath = props.getProperty("distributionPath");
            if (!StringUtil.isEmpty((String)distributionPath)) {
                wrapperConfiguration.setDistributionPath(distributionPath);
            }
            if (!StringUtil.isEmpty((String)(distPathBase = props.getProperty("distributionBase")))) {
                wrapperConfiguration.setDistributionBase(distPathBase);
            }
            WrapperConfiguration wrapperConfiguration2 = wrapperConfiguration;
            return wrapperConfiguration2;
        }
        catch (Exception e) {
            GradleLog.LOG.warn(String.format("I/O exception on reading gradle wrapper properties file at '%s'", wrapperPropertiesFile.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    @NotNull
    public static String getConfigPath(@NotNull GradleProject subProject, @NotNull String rootProjectPath) {
        block9: {
            String string;
            if (subProject == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/util/GradleUtil", "getConfigPath"));
            }
            if (rootProjectPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/util/GradleUtil", "getConfigPath"));
            }
            try {
                File file;
                GradleScript script = subProject.getBuildScript();
                if (script == null || (file = script.getSourceFile()) == null) break block9;
                if (file.isFile()) {
                    file = file.getParentFile();
                }
                string = ExternalSystemApiUtil.toCanonicalPath((String)file.getCanonicalPath());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/util/GradleUtil", "getConfigPath"));
            }
            return string;
        }
        File rootProjectParent = new File(rootProjectPath);
        StringBuilder buffer = new StringBuilder(FileUtil.toCanonicalPath((String)rootProjectParent.getAbsolutePath()));
        Stack stack = ContainerUtilRt.newStack();
        for (GradleProject p = subProject; p != null; p = p.getParent()) {
            stack.push((Object)p.getName());
        }
        stack.pop();
        while (!stack.isEmpty()) {
            buffer.append('/').append((String)stack.pop());
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/util/GradleUtil", "getConfigPath"));
        }
        return string;
    }

    @NotNull
    public static String getLastUsedGradleHome() {
        String string = PropertiesComponent.getInstance().getValue(LAST_USED_GRADLE_HOME_KEY, "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/util/GradleUtil", "getLastUsedGradleHome"));
        }
        return string;
    }

    public static void storeLastUsedGradleHome(@Nullable String gradleHomePath) {
        if (gradleHomePath != null) {
            PropertiesComponent.getInstance().setValue(LAST_USED_GRADLE_HOME_KEY, gradleHomePath);
        }
    }

    @Nullable
    public static File findDefaultWrapperPropertiesFile(@Nullable String gradleProjectPath) {
        if (gradleProjectPath == null) {
            return null;
        }
        File file = new File(gradleProjectPath);
        File gradleDir = file.isFile() ? new File(file.getParentFile(), "gradle") : new File(file, "gradle");
        if (!gradleDir.isDirectory()) {
            return null;
        }
        File wrapperDir = new File(gradleDir, "wrapper");
        if (!wrapperDir.isDirectory()) {
            return null;
        }
        Object[] candidates = wrapperDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File candidate) {
                return candidate.isFile() && candidate.getName().endsWith(".properties");
            }
        });
        if (candidates == null) {
            GradleLog.LOG.warn("No *.properties file is found at the gradle wrapper directory " + wrapperDir.getAbsolutePath());
            return null;
        }
        if (candidates.length != 1) {
            GradleLog.LOG.warn(String.format("%d *.properties files instead of one have been found at the wrapper directory (%s): %s", candidates.length, wrapperDir.getAbsolutePath(), Arrays.toString(candidates)));
            return null;
        }
        return candidates[0];
    }

    @NotNull
    public static String createJvmArg(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/util/GradleUtil", "createJvmArg"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/util/GradleUtil", "createJvmArg"));
        }
        String string = String.format(JVM_ARG_FORMAT, name, value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/util/GradleUtil", "createJvmArg"));
        }
        return string;
    }

    private static class DescriptorHolder {
        public static final FileChooserDescriptor GRADLE_BUILD_FILE_CHOOSER_DESCRIPTOR = new OpenProjectFileChooserDescriptor(true){

            public boolean isFileSelectable(VirtualFile file) {
                return file.getName().endsWith("gradle");
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                return file.isDirectory() || file.getName().endsWith("gradle");
            }
        };
        public static final FileChooserDescriptor GRADLE_HOME_FILE_CHOOSER_DESCRIPTOR = new FileChooserDescriptor(false, true, false, false, false, false);

        private DescriptorHolder() {
        }
    }
}

