/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GradleSystemSettings", storages={@Storage(file="$APP_CONFIG$/gradle.settings.xml")})
public class GradleSystemSettings
implements PersistentStateComponent<MyState> {
    @Nullable
    private String myServiceDirectoryPath;
    @Nullable
    private String myGradleVmOptions;
    private boolean myIsOfflineWork;

    @NotNull
    public static GradleSystemSettings getInstance() {
        GradleSystemSettings gradleSystemSettings = (GradleSystemSettings)ServiceManager.getService(GradleSystemSettings.class);
        if (gradleSystemSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/GradleSystemSettings", "getInstance"));
        }
        return gradleSystemSettings;
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        state.serviceDirectoryPath = this.myServiceDirectoryPath;
        state.gradleVmOptions = this.myGradleVmOptions;
        state.offlineWork = this.myIsOfflineWork;
        return state;
    }

    public void loadState(MyState state) {
        this.myServiceDirectoryPath = state.serviceDirectoryPath;
        this.myGradleVmOptions = state.gradleVmOptions;
        this.myIsOfflineWork = state.offlineWork;
    }

    @Nullable
    public String getServiceDirectoryPath() {
        return this.myServiceDirectoryPath;
    }

    public void setServiceDirectoryPath(@Nullable String newPath) {
        this.myServiceDirectoryPath = newPath;
    }

    @Nullable
    public String getGradleVmOptions() {
        return this.myGradleVmOptions;
    }

    public void setGradleVmOptions(@Nullable String gradleVmOptions) {
        this.myGradleVmOptions = gradleVmOptions;
    }

    public boolean isOfflineWork() {
        return this.myIsOfflineWork;
    }

    public void setOfflineWork(boolean isOfflineWork) {
        this.myIsOfflineWork = isOfflineWork;
    }

    public static class MyState {
        public String serviceDirectoryPath;
        public String gradleVmOptions;
        public boolean offlineWork;
    }
}

