/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassHolder<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myClassName;
    @Nullable
    private transient Class<T> myTargetClass;

    public ClassHolder(@NotNull Class<T> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/settings/ClassHolder", "<init>"));
        }
        this.myTargetClass = targetClass;
        this.myClassName = this.myTargetClass.getName();
    }

    @NotNull
    public static <T> ClassHolder<T> from(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/settings/ClassHolder", "from"));
        }
        ClassHolder<T> classHolder = new ClassHolder<T>(clazz);
        if (classHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/ClassHolder", "from"));
        }
        return classHolder;
    }

    @NotNull
    public Class<T> getTargetClass() throws ClassNotFoundException {
        if (this.myTargetClass == null) {
            this.myTargetClass = Class.forName(this.myClassName);
        }
        Class<T> clazz = this.myTargetClass;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/ClassHolder", "getTargetClass"));
        }
        return clazz;
    }

    @NotNull
    public String getTargetClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/settings/ClassHolder", "getTargetClassName"));
        }
        return string;
    }

    public int hashCode() {
        return this.myClassName.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassHolder holder = (ClassHolder)o;
        if (!this.myClassName.equals(holder.myClassName)) {
            return false;
        }
        return !(this.myTargetClass != null ? !this.myTargetClass.equals(holder.myTargetClass) : holder.myTargetClass != null);
    }

    public String toString() {
        return this.myClassName;
    }
}

