/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.externalSystem.service.settings.AbstractExternalSystemConfigurable;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControl;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControl;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleConfigurable
extends AbstractExternalSystemConfigurable<GradleProjectSettings, GradleSettingsListener, GradleSettings> {
    @NonNls
    public static final String HELP_TOPIC = "reference.settingsdialog.project.gradle";

    public GradleConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/settings/GradleConfigurable", "<init>"));
        }
        super(project, GradleConstants.SYSTEM_ID);
    }

    @NotNull
    protected ExternalSystemSettingsControl<GradleProjectSettings> createProjectSettingsControl(@NotNull GradleProjectSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/settings/GradleConfigurable", "createProjectSettingsControl"));
        }
        GradleProjectSettingsControl gradleProjectSettingsControl = new GradleProjectSettingsControl(settings);
        if (gradleProjectSettingsControl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/GradleConfigurable", "createProjectSettingsControl"));
        }
        return gradleProjectSettingsControl;
    }

    @Nullable
    protected ExternalSystemSettingsControl<GradleSettings> createSystemSettingsControl(@NotNull GradleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/settings/GradleConfigurable", "createSystemSettingsControl"));
        }
        return new GradleSystemSettingsControl(settings);
    }

    @NotNull
    protected GradleProjectSettings newProjectSettings() {
        GradleProjectSettings gradleProjectSettings = new GradleProjectSettings();
        if (gradleProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/GradleConfigurable", "newProjectSettings"));
        }
        return gradleProjectSettings;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/GradleConfigurable", "getId"));
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        if (HELP_TOPIC == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/GradleConfigurable", "getHelpTopic"));
        }
        return HELP_TOPIC;
    }
}

