/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;

public class GradleSourceSetsContributor
implements GradleMethodContextContributor {
    static final String SOURCE_SETS = "sourceSets";
    private static final String CONFIGURE_CLOSURE_METHOD = "configure";
    private static final int SOURCE_SET_CONTAINER_LEVEL = 1;
    private static final int SOURCE_SET_LEVEL = 2;
    private static final int SOURCE_DIRECTORY_LEVEL = 3;
    private static final int SOURCE_DIRECTORY_CLOSURE_LEVEL = 4;

    @Override
    public void process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        GrLightMethodBuilder methodWithClosure;
        GroovyPsiManager psiManager;
        if (methodCallInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/resolve/GradleSourceSetsContributor", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/resolve/GradleSourceSetsContributor", "process"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/service/resolve/GradleSourceSetsContributor", "process"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/gradle/service/resolve/GradleSourceSetsContributor", "process"));
        }
        if (methodCallInfo.isEmpty()) {
            return;
        }
        String methodCall = (String)ContainerUtil.getLastItem(methodCallInfo);
        if (methodCall == null) {
            return;
        }
        if (methodCallInfo.size() > 1 && SOURCE_SETS.equals(place.getText()) && place instanceof GrReferenceExpressionImpl) {
            GradleResolverUtil.addImplicitVariable(processor, state, (GrReferenceExpressionImpl)place, "org.gradle.api.tasks.SourceSetContainer");
        }
        if (methodCallInfo.size() > 1 && methodCall.equals("project")) {
            methodCallInfo.remove(methodCallInfo.size() - 1);
            methodCall = (String)ContainerUtil.getLastItem(methodCallInfo);
        }
        if (methodCall == null || methodCallInfo.size() > 4 || !StringUtil.startsWith((CharSequence)methodCall, (CharSequence)SOURCE_SETS)) {
            return;
        }
        String configureClosureClazz = null;
        String contributorClass = null;
        boolean isRootRelated = StringUtil.startsWith((CharSequence)methodCall, (CharSequence)"sourceSets.");
        if (methodCallInfo.size() == 1) {
            configureClosureClazz = "org.gradle.api.tasks.SourceSetContainer";
            if (place instanceof GrReferenceExpressionImpl) {
                String varClazz = StringUtil.startsWith((CharSequence)methodCall, (CharSequence)"sourceSets.") ? "org.gradle.api.tasks.SourceSetContainer" : "org.gradle.api.tasks.SourceSet";
                GradleResolverUtil.addImplicitVariable(processor, state, (GrReferenceExpressionImpl)place, varClazz);
            } else {
                contributorClass = "org.gradle.api.tasks.SourceSetContainer";
            }
        } else if (methodCallInfo.size() == 2) {
            configureClosureClazz = "org.gradle.api.tasks.SourceSet";
            contributorClass = "org.gradle.api.tasks.SourceSet";
        } else if (methodCallInfo.size() == 3) {
            psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
            PsiClass psiClass = psiManager.findClassWithCache("org.gradle.api.tasks.SourceSet", place.getResolveScope());
            configureClosureClazz = GradleResolverUtil.canBeMethodOf(place.getText(), psiClass) ? null : "org.gradle.api.file.SourceDirectorySet";
            contributorClass = "org.gradle.api.file.SourceDirectorySet";
        } else if (methodCallInfo.size() == 4) {
            contributorClass = "org.gradle.api.file.SourceDirectorySet";
        }
        if (configureClosureClazz != null && !isRootRelated && (methodWithClosure = GradleResolverUtil.createMethodWithClosure(CONFIGURE_CLOSURE_METHOD, configureClosureClazz, null, place, psiManager = GroovyPsiManager.getInstance((Project)place.getProject()))) != null) {
            processor.execute((PsiElement)methodWithClosure, state);
        }
        if (contributorClass != null) {
            psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
            GradleResolverUtil.processDeclarations(psiManager, processor, state, place, contributorClass);
        }
    }
}

