/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public abstract class GradleSimpleContributor
implements GradleMethodContextContributor {
    private final String blockName;
    private final String fqName;
    private final List<String> myMixIns;

    protected GradleSimpleContributor(@NotNull String blockName, @NotNull String fqName, String ... mixIns) {
        if (blockName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/resolve/GradleSimpleContributor", "<init>"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/resolve/GradleSimpleContributor", "<init>"));
        }
        this.blockName = blockName;
        this.fqName = fqName;
        this.myMixIns = ContainerUtil.newArrayList((Object[])mixIns);
    }

    @Override
    public void process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (methodCallInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/resolve/GradleSimpleContributor", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/resolve/GradleSimpleContributor", "process"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/service/resolve/GradleSimpleContributor", "process"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/gradle/service/resolve/GradleSimpleContributor", "process"));
        }
        if (methodCallInfo.isEmpty() || methodCallInfo.size() < 2 || !this.blockName.equals(methodCallInfo.get(1))) {
            return;
        }
        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        GradleResolverUtil.processDeclarations(psiManager, processor, state, place, this.fqName);
        for (String mixin : this.myMixIns) {
            PsiClass contributorClass = psiManager.findClassWithCache(mixin, place.getResolveScope());
            if (contributorClass == null) continue;
            GradleResolverUtil.processMethod(methodCallInfo.get(0), contributorClass, processor, state, place);
        }
    }
}

