/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;

public class GradleScriptContributor
extends NonCodeMembersContributor {
    public static final Set<String> BUILD_PROJECT_SCRIPT_BLOCKS = ContainerUtil.newHashSet((Object[])new String[]{"project", "configure", "subprojects", "allprojects", "buildscript"});

    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/resolve/GradleScriptContributor", "processDynamicElements"));
        }
        if (place == null) {
            return;
        }
        if (!(aClass instanceof GroovyScriptClass)) {
            return;
        }
        PsiFile file = aClass.getContainingFile();
        if (file == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle") || "settings.gradle".equals(file.getName())) {
            return;
        }
        ArrayList methodInfo = ContainerUtilRt.newArrayList();
        GrMethodCall current = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        while (current != null) {
            String text;
            GrExpression expression = current.getInvokedExpression();
            if (expression != null && (text = expression.getText()) != null) {
                methodInfo.add(text);
            }
            current = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)current, GrMethodCall.class);
        }
        String methodCall = (String)ContainerUtil.getLastItem((List)methodInfo);
        if (methodInfo.size() > 1 && BUILD_PROJECT_SCRIPT_BLOCKS.contains(methodCall)) {
            methodInfo.remove(methodInfo.size() - 1);
        }
        for (GradleMethodContextContributor contributor : (GradleMethodContextContributor[])GradleMethodContextContributor.EP_NAME.getExtensions()) {
            contributor.process(methodInfo, processor, state, place);
        }
    }
}

