/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import java.util.Collection;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class ProjectResolverContext {
    @NotNull
    private final ExternalSystemTaskId myExternalSystemTaskId;
    @NotNull
    private final String myProjectPath;
    @Nullable
    private final GradleExecutionSettings mySettings;
    @NotNull
    private final ProjectConnection myConnection;
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    private final boolean myIsPreviewMode;
    @NotNull
    private ProjectImportAction.AllModels myModels;

    public ProjectResolverContext(@NotNull ExternalSystemTaskId externalSystemTaskId, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener, boolean isPreviewMode) {
        if (externalSystemTaskId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "<init>"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "<init>"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "<init>"));
        }
        this.myExternalSystemTaskId = externalSystemTaskId;
        this.myProjectPath = projectPath;
        this.mySettings = settings;
        this.myConnection = connection;
        this.myListener = listener;
        this.myIsPreviewMode = isPreviewMode;
    }

    @NotNull
    public ExternalSystemTaskId getExternalSystemTaskId() {
        ExternalSystemTaskId externalSystemTaskId = this.myExternalSystemTaskId;
        if (externalSystemTaskId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "getExternalSystemTaskId"));
        }
        return externalSystemTaskId;
    }

    @NotNull
    public String getProjectPath() {
        String string = this.myProjectPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "getProjectPath"));
        }
        return string;
    }

    @Nullable
    public GradleExecutionSettings getSettings() {
        return this.mySettings;
    }

    @NotNull
    public ProjectConnection getConnection() {
        ProjectConnection projectConnection = this.myConnection;
        if (projectConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "getConnection"));
        }
        return projectConnection;
    }

    @NotNull
    public ExternalSystemTaskNotificationListener getListener() {
        ExternalSystemTaskNotificationListener externalSystemTaskNotificationListener = this.myListener;
        if (externalSystemTaskNotificationListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "getListener"));
        }
        return externalSystemTaskNotificationListener;
    }

    public boolean isPreviewMode() {
        return this.myIsPreviewMode;
    }

    @NotNull
    public ProjectImportAction.AllModels getModels() {
        ProjectImportAction.AllModels allModels = this.myModels;
        if (allModels == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "getModels"));
        }
        return allModels;
    }

    public void setModels(@NotNull ProjectImportAction.AllModels models) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "setModels"));
        }
        this.myModels = models;
    }

    @Nullable
    public <T> T getExtraProject(@NotNull IdeaModule module, Class<T> modelClazz) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "getExtraProject"));
        }
        return (T)this.myModels.getExtraProject(module, modelClazz);
    }

    @NotNull
    public Collection<String> findModulesWithModel(@NotNull Class modelClazz) {
        if (modelClazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "findModulesWithModel"));
        }
        Collection collection = this.myModels.findModulesWithModel(modelClazz);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/ProjectResolverContext", "findModulesWithModel"));
        }
        return collection;
    }
}

