/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputWrapper
extends OutputStream {
    @NotNull
    private final ExternalSystemTaskNotificationListener myListener;
    @NotNull
    private final ExternalSystemTaskId myTaskId;
    @Nullable
    private StringBuilder myBuffer;
    private final boolean myStdOut;

    public OutputWrapper(@NotNull ExternalSystemTaskNotificationListener listener, @NotNull ExternalSystemTaskId taskId, boolean stdOut) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/OutputWrapper", "<init>"));
        }
        if (taskId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/project/OutputWrapper", "<init>"));
        }
        this.myListener = listener;
        this.myTaskId = taskId;
        this.myStdOut = stdOut;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.myBuffer == null) {
            this.myBuffer = new StringBuilder();
        }
        char c = (char)b;
        this.myBuffer.append(Character.toString(c));
        if (c == '\n') {
            this.doFlush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int start = off;
        int maxOffset = off + len;
        for (int i = off; i < maxOffset; ++i) {
            if (b[i] != 10) continue;
            if (this.myBuffer == null) {
                this.myBuffer = new StringBuilder();
            }
            this.myBuffer.append(new String(b, start, i - start + 1));
            this.doFlush();
            start = i + 1;
        }
        if (start < maxOffset) {
            if (this.myBuffer == null) {
                this.myBuffer = new StringBuilder();
            }
            this.myBuffer.append(new String(b, start, maxOffset - start));
        }
    }

    private void doFlush() {
        if (this.myBuffer == null) {
            return;
        }
        this.myListener.onTaskOutput(this.myTaskId, this.myBuffer.toString(), this.myStdOut);
        this.myBuffer.setLength(0);
    }
}

