/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleNotification {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Gradle Notification Group");
    @NotNull
    private final Project myProject;

    @NotNull
    public static GradleNotification getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "getInstance"));
        }
        GradleNotification gradleNotification = (GradleNotification)ServiceManager.getService((Project)project, GradleNotification.class);
        if (gradleNotification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "getInstance"));
        }
        return gradleNotification;
    }

    public GradleNotification(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "<init>"));
        }
        this.myProject = project;
    }

    public void showBalloon(final @NotNull String title, final @NotNull String message, final @NotNull NotificationType type, final @Nullable NotificationListener listener) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "showBalloon"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "showBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/service/project/GradleNotification", "showBalloon"));
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                NOTIFICATION_GROUP.createNotification(title, message, type, listener).notify(GradleNotification.this.myProject);
            }
        });
    }
}

