/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.WebResource;

public class War
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myName;
    @NotNull
    private final String myWebAppDirName;
    @NotNull
    private final File myWebAppDir;
    @Nullable
    private File myWebXml;
    @NotNull
    private List<WebResource> myWebResources;
    @NotNull
    private Set<File> myClasspath;
    @Nullable
    private String myManifestContent;

    public War(@NotNull String name, @NotNull String webAppDirName, @NotNull File webAppDir) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/model/data/War", "<init>"));
        }
        if (webAppDirName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/model/data/War", "<init>"));
        }
        if (webAppDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/model/data/War", "<init>"));
        }
        this.myName = name;
        this.myWebAppDirName = webAppDirName;
        this.myWebAppDir = webAppDir;
        this.myWebResources = Collections.emptyList();
        this.myClasspath = Collections.emptySet();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/War", "getName"));
        }
        return string;
    }

    @NotNull
    public String getWebAppDirName() {
        String string = this.myWebAppDirName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/War", "getWebAppDirName"));
        }
        return string;
    }

    @NotNull
    public File getWebAppDir() {
        File file = this.myWebAppDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/War", "getWebAppDir"));
        }
        return file;
    }

    public void setWebXml(@Nullable File webXml) {
        this.myWebXml = webXml;
    }

    @Nullable
    public File getWebXml() {
        return this.myWebXml;
    }

    public void setWebResources(@Nullable List<WebResource> webResources) {
        this.myWebResources = webResources == null ? Collections.emptyList() : webResources;
    }

    @NotNull
    public List<WebResource> getWebResources() {
        List<WebResource> list = this.myWebResources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/War", "getWebResources"));
        }
        return list;
    }

    public void setClasspath(@Nullable Set<File> classpath) {
        this.myClasspath = classpath == null ? Collections.emptySet() : classpath;
    }

    @NotNull
    public Set<File> getClasspath() {
        Set<File> set = this.myClasspath;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/War", "getClasspath"));
        }
        return set;
    }

    public void setManifestContent(@Nullable String manifestContent) {
        this.myManifestContent = manifestContent;
    }

    @Nullable
    public String getManifestContent() {
        return this.myManifestContent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        War that = (War)o;
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.myWebAppDirName.equals(that.myWebAppDirName)) {
            return false;
        }
        return ((Object)this.myWebResources).equals(that.myWebResources);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myWebAppDirName.hashCode();
        result = 31 * result + ((Object)this.myWebResources).hashCode();
        return result;
    }

    public String toString() {
        return "War{myName='" + this.myName + '\'' + ", myWebAppDirName='" + this.myWebAppDirName + '\'' + ", myWebAppDir=" + this.myWebAppDir + ", myWebXml=" + this.myWebXml + ", myWebResources=" + this.myWebResources + '}';
    }
}

