/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.ui.RichTextControlBuilder;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public abstract class GradleToolWindowPanel
extends SimpleToolWindowPanel {
    private static final String NON_LINKED_CARD_NAME = "NON_LINKED";
    private static final String CONTENT_CARD_NAME = "CONTENT";
    private static final String TOOL_WINDOW_TOOLBAR_ID = "Gradle.ChangeActionsToolbar";
    private final CardLayout myLayout;
    private final JPanel myContent;
    private final Project myProject;
    private final String myPlace;

    protected GradleToolWindowPanel(@NotNull Project project, @NotNull String place) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/config/GradleToolWindowPanel", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/config/GradleToolWindowPanel", "<init>"));
        }
        super(true);
        this.myLayout = new CardLayout();
        this.myContent = new JPanel(this.myLayout);
        this.myProject = project;
        this.myPlace = place;
        this.setContent(this.myContent);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(GradleSettingsListener.TOPIC, (Object)new GradleSettingsListenerAdapter(){});
    }

    public void initContent() {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup actionGroup = (ActionGroup)actionManager.getAction(TOOL_WINDOW_TOOLBAR_ID);
        ActionToolbar actionToolbar = actionManager.createActionToolbar(this.myPlace, actionGroup, true);
        JPanel toolbarControl = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        toolbarControl.add((Component)actionToolbar.getComponent(), constraints);
        for (JComponent component : this.getToolbarControls()) {
            component.setBorder(IdeBorderFactory.createBorder((int)2));
            toolbarControl.add((Component)component, constraints);
        }
        this.setToolbar(toolbarControl);
        JComponent payloadControl = this.buildContent();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)payloadControl);
        JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        scrollBar.setUnitIncrement(scrollBar.getUnitIncrement() * 7);
        this.myContent.add((Component)scrollPane, CONTENT_CARD_NAME);
        RichTextControlBuilder builder = new RichTextControlBuilder();
        builder.setBackgroundColor(payloadControl.getBackground());
        builder.setForegroundColor(UIUtil.getInactiveTextColor());
        builder.setFont(payloadControl.getFont());
        builder.setText(GradleBundle.message("gradle.toolwindow.text.no.linked.project", new Object[0]));
        JComponent noLinkedProjectControl = builder.build();
        this.myContent.add((Component)noLinkedProjectControl, NON_LINKED_CARD_NAME);
        this.update();
    }

    @NotNull
    protected List<JComponent> getToolbarControls() {
        List<JComponent> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/config/GradleToolWindowPanel", "getToolbarControls"));
        }
        return list;
    }

    public void update() {
        GradleSettings settings = GradleSettings.getInstance(this.myProject);
        String cardToShow = "sf";
        this.myLayout.show(this.myContent, cardToShow);
        boolean showToolbar = cardToShow != NON_LINKED_CARD_NAME;
        for (JComponent component : this.getToolbarControls()) {
            component.setVisible(showToolbar);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/config/GradleToolWindowPanel", "getProject"));
        }
        return project;
    }

    @NotNull
    protected abstract JComponent buildContent();

    protected abstract void updateContent();
}

