/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.MultipleRepositoryUrlsFix;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public class MultipleRepositoryUrlsInspection
extends GradleBaseInspection {
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        MyVisitor myVisitor = new MyVisitor();
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection", "buildVisitor"));
        }
        return myVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    protected String buildErrorString(Object ... args) {
        return GradleInspectionBundle.message("multiple.repository.urls", args);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GradleInspectionBundle.message("multiple.repository.urls", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    static List<GrCallExpression> findUrlCallExpressions(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection", "findUrlCallExpressions"));
        }
        GrCallExpression[] applicationStatements = (GrCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)closure, GrCallExpression.class);
        if (applicationStatements == null) {
            List<GrCallExpression> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection", "findUrlCallExpressions"));
            }
            return list;
        }
        ArrayList statements = ContainerUtil.newArrayList();
        for (GrCallExpression statement : applicationStatements) {
            GrReferenceExpression[] referenceExpressions = (GrReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)statement, GrReferenceExpression.class);
            if (referenceExpressions == null) continue;
            for (GrReferenceExpression expression : referenceExpressions) {
                String expressionText = expression.getText();
                if (!"url".equals(expressionText) && !"setUrl".equals(expressionText)) continue;
                statements.add(statement);
            }
        }
        ArrayList arrayList = statements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection", "findUrlCallExpressions"));
        }
        return arrayList;
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        public void visitClosure(GrClosableBlock closure) {
            PsiFile file = closure.getContainingFile();
            if (file == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
                return;
            }
            super.visitClosure(closure);
            GrMethodCall mavenMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)closure, GrMethodCall.class);
            if (mavenMethodCall == null) {
                return;
            }
            GrExpression mavenMethodExpression = mavenMethodCall.getInvokedExpression();
            if (mavenMethodExpression == null || !ArrayUtil.contains((String)mavenMethodExpression.getText(), (String[])new String[]{"maven", "ivy"})) {
                return;
            }
            GrMethodCall repositoryMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)mavenMethodCall, GrMethodCall.class);
            if (repositoryMethodCall == null) {
                return;
            }
            GrExpression repositoryMethodExpression = repositoryMethodCall.getInvokedExpression();
            if (repositoryMethodExpression == null || !repositoryMethodExpression.getText().equals("repositories")) {
                return;
            }
            List<GrCallExpression> statements = MultipleRepositoryUrlsInspection.findUrlCallExpressions(closure);
            if (statements.size() > 1) {
                this.registerError((PsiElement)closure);
                this.registerError((PsiElement)closure, GradleInspectionBundle.message("multiple.repository.urls", new Object[0]), new LocalQuickFix[]{new MultipleRepositoryUrlsFix(closure, mavenMethodExpression.getText())}, ProblemHighlightType.GENERIC_ERROR);
            }
        }
    }
}

