/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import org.jetbrains.annotations.NotNull;

public class AndroidNativeLibData {
    private final String myPath;
    private final String myArchitecture;
    private final String myTargetFileName;

    public AndroidNativeLibData(@NotNull String architecture, @NotNull String path, @NotNull String targetFileName) {
        if (architecture == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/android/util/AndroidNativeLibData", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/android/util/AndroidNativeLibData", "<init>"));
        }
        if (targetFileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/android/util/AndroidNativeLibData", "<init>"));
        }
        this.myPath = path;
        this.myArchitecture = architecture;
        this.myTargetFileName = targetFileName;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidNativeLibData", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getArchitecture() {
        String string = this.myArchitecture;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidNativeLibData", "getArchitecture"));
        }
        return string;
    }

    @NotNull
    public String getTargetFileName() {
        String string = this.myTargetFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/AndroidNativeLibData", "getTargetFileName"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidNativeLibData lib = (AndroidNativeLibData)o;
        if (!this.myArchitecture.equals(lib.myArchitecture)) {
            return false;
        }
        if (!this.myTargetFileName.equals(lib.myTargetFileName)) {
            return false;
        }
        return this.myPath.equals(lib.myPath);
    }

    public String toString() {
        return "[" + this.myPath + "," + this.myArchitecture + "," + this.myTargetFileName + "]";
    }

    public int hashCode() {
        int result = this.myPath.hashCode();
        result = 31 * result + this.myArchitecture.hashCode();
        result = 31 * result + this.myTargetFileName.hashCode();
        return result;
    }
}

