/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidGradleSettings {
    private static final Logger LOG = Logger.getInstance(AndroidGradleSettings.class);
    @NonNls
    private static final String JVM_ARG_FORMAT = "-D%1$s=%2$s";
    @NonNls
    private static final String PROJECT_PROPERTY_FORMAT = "-P%1$s=%2$s";
    @NonNls
    public static final String ANDROID_HOME_JVM_ARG = "android.home";

    private AndroidGradleSettings() {
    }

    public static boolean isAndroidSdkDirInLocalPropertiesFile(@NotNull File projectDir) {
        if (projectDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "isAndroidSdkDirInLocalPropertiesFile"));
        }
        String androidHome = AndroidGradleSettings.getAndroidHomeFromLocalPropertiesFile(projectDir);
        if (!Strings.isNullOrEmpty((String)androidHome)) {
            String msg = String.format("Found Android SDK home at '%1$s' (from local.properties file)", androidHome);
            LOG.info(msg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getAndroidHomeFromLocalPropertiesFile(@NotNull File projectDir) {
        if (projectDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "getAndroidHomeFromLocalPropertiesFile"));
        }
        File filePath = new File(projectDir, "local.properties");
        if (!filePath.isFile()) {
            return null;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String msg = String.format("Failed to read file '%1$s'", filePath.getPath());
            LOG.error(msg, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                Closeables.close((Closeable)fileInputStream, (boolean)true);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return properties.getProperty("sdk.dir");
    }

    @NotNull
    public static String createAndroidHomeJvmArg(@NotNull String androidHome) {
        if (androidHome == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createAndroidHomeJvmArg"));
        }
        String string = AndroidGradleSettings.createJvmArg(ANDROID_HOME_JVM_ARG, androidHome);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createAndroidHomeJvmArg"));
        }
        return string;
    }

    @NotNull
    public static String createJvmArg(@NotNull String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createJvmArg"));
        }
        String string = AndroidGradleSettings.createJvmArg(name, String.valueOf(value));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createJvmArg"));
        }
        return string;
    }

    @NotNull
    public static String createJvmArg(@NotNull String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createJvmArg"));
        }
        String string = AndroidGradleSettings.createJvmArg(name, String.valueOf(value));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createJvmArg"));
        }
        return string;
    }

    @NotNull
    public static String createJvmArg(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createJvmArg"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createJvmArg"));
        }
        String string = String.format(JVM_ARG_FORMAT, name, value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createJvmArg"));
        }
        return string;
    }

    @NotNull
    public static String createProjectProperty(@NotNull String name, @NotNull boolean value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createProjectProperty"));
        }
        String string = AndroidGradleSettings.createProjectProperty(name, String.valueOf(value));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createProjectProperty"));
        }
        return string;
    }

    @NotNull
    public static String createProjectProperty(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createProjectProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createProjectProperty"));
        }
        String string = String.format(PROJECT_PROPERTY_FORMAT, name, value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/AndroidGradleSettings", "createProjectProperty"));
        }
        return string;
    }
}

