/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.ParsingFailedException;
import com.android.tools.idea.gradle.output.parser.PatternAwareOutputParser;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class GradleOutputParser
implements PatternAwareOutputParser {
    private static final Pattern ERROR_COUNT_PATTERN = Pattern.compile("[\\d]+ error(s)?");

    GradleOutputParser() {
    }

    @Override
    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<GradleMessage> messages) throws ParsingFailedException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/output/parser/GradleOutputParser", "parse"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/gradle/output/parser/GradleOutputParser", "parse"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/android/tools/idea/gradle/output/parser/GradleOutputParser", "parse"));
        }
        if (GradleOutputParser.ignoreMessage(line)) {
            return true;
        }
        if (line.endsWith("is an incubating feature.") || line.contains("has been deprecated and is scheduled to be removed in Gradle")) {
            return true;
        }
        if (line.startsWith("Total time: ") || line.startsWith("BUILD ")) {
            messages.add(new GradleMessage(GradleMessage.Kind.INFO, line));
            return true;
        }
        return false;
    }

    private static boolean ignoreMessage(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/android/tools/idea/gradle/output/parser/GradleOutputParser", "ignoreMessage"));
        }
        return line.trim().equalsIgnoreCase("FAILED") || ERROR_COUNT_PATTERN.matcher(line).matches();
    }
}

