/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxControllerBasedReferenceProvider;

public class JavaFxFieldIdReferenceProvider
extends JavaFxControllerBasedReferenceProvider {
    @Override
    protected PsiReference[] getReferencesByElement(@NotNull PsiClass aClass, XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFieldIdReferenceProvider", "getReferencesByElement"));
        }
        PsiField field = aClass.findFieldByName(xmlAttributeValue.getValue(), true);
        return new PsiReference[]{new JavaFxControllerFieldRef(xmlAttributeValue, field, aClass)};
    }

    public static class JavaFxControllerFieldRef
    extends PsiReferenceBase<XmlAttributeValue> {
        private final XmlAttributeValue myXmlAttributeValue;
        private final PsiField myField;
        private final PsiClass myAClass;

        public JavaFxControllerFieldRef(XmlAttributeValue xmlAttributeValue, PsiField field, PsiClass aClass) {
            super((PsiElement)xmlAttributeValue, true);
            this.myXmlAttributeValue = xmlAttributeValue;
            this.myField = field;
            this.myAClass = aClass;
        }

        public XmlAttributeValue getXmlAttributeValue() {
            return this.myXmlAttributeValue;
        }

        public PsiClass getAClass() {
            return this.myAClass;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myField != null ? this.myField : this.myXmlAttributeValue;
        }

        public boolean isUnresolved() {
            XmlFile xmlFile;
            return this.myField == null && this.myAClass != null && (xmlFile = (XmlFile)this.myXmlAttributeValue.getContainingFile()).getRootTag() != null && !JavaFxPsiUtil.isOutOfHierarchy(this.myXmlAttributeValue);
        }

        @NotNull
        public Object[] getVariants() {
            PsiField[] fields;
            ArrayList<PsiField> fieldsToSuggest = new ArrayList<PsiField>();
            for (PsiField psiField : fields = this.myAClass.getFields()) {
                if (psiField.hasModifierProperty("static") || !JavaFxPsiUtil.isVisibleInFxml((PsiMember)psiField)) continue;
                fieldsToSuggest.add(psiField);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(fieldsToSuggest);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFieldIdReferenceProvider$JavaFxControllerFieldRef", "getVariants"));
            }
            return objectArray;
        }
    }
}

