/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxControllerBasedReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxEventHandlerReference;

class JavaFxEventHandlerReferenceProvider
extends JavaFxControllerBasedReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFxEventHandlerReferenceProvider.class.getName()));

    JavaFxEventHandlerReferenceProvider() {
    }

    @Override
    protected PsiReference[] getReferencesByElement(@NotNull PsiClass controllerClass, XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        XmlTag rootTag;
        if (controllerClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReferenceProvider", "getReferencesByElement"));
        }
        String attValueString = xmlAttributeValue.getValue();
        LOG.assertTrue(attValueString.startsWith("#"));
        XmlAttribute attribute = (XmlAttribute)xmlAttributeValue.getContext();
        if (attribute == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (!JavaFxPsiUtil.checkIfAttributeHandler(attribute)) {
            return PsiReference.EMPTY_ARRAY;
        }
        XmlElementDescriptor descriptor = attribute.getParent().getDescriptor();
        if (descriptor == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement currentTagClass = descriptor.getDeclaration();
        String eventHandlerName = attValueString.substring(1);
        PsiMethod[] methods = controllerClass.findMethodsByName(eventHandlerName, true);
        PsiMethod handlerMethod = null;
        for (PsiMethod psiMethod : methods) {
            if (!JavaFxEventHandlerReference.isHandlerMethod(psiMethod)) continue;
            handlerMethod = psiMethod;
            break;
        }
        if (handlerMethod == null && ((rootTag = ((XmlFile)xmlAttributeValue.getContainingFile()).getRootTag()) == null || "fx:root".equals(rootTag.getName()))) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new PsiReference[]{new JavaFxEventHandlerReference(xmlAttributeValue, (PsiClass)currentTagClass, handlerMethod, controllerClass)};
    }
}

