/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public abstract class JavaFxControllerBasedReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public final PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerBasedReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerBasedReferenceProvider", "getReferencesByElement"));
        }
        XmlAttributeValue xmlAttrVal = (XmlAttributeValue)element;
        PsiFile containingFile = xmlAttrVal.getContainingFile();
        if (!JavaFxFileTypeFactory.isFxml(containingFile)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerBasedReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiClass controllerClass = JavaFxPsiUtil.getControllerClass(containingFile);
        if (controllerClass != null) {
            psiReferenceArray = this.getReferencesByElement(controllerClass, xmlAttrVal, context);
        } else {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = new PsiReferenceBase.Immediate((PsiElement)xmlAttrVal, (PsiElement)xmlAttrVal);
        }
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxControllerBasedReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    protected abstract PsiReference[] getReferencesByElement(@NotNull PsiClass var1, XmlAttributeValue var2, ProcessingContext var3);
}

