/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassBackedElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxDefaultPropertyElementDescriptor;

public class JavaFxPropertyElementDescriptor
implements XmlElementDescriptor {
    private final PsiClass myPsiClass;
    private final String myName;
    private final boolean myStatic;

    public JavaFxPropertyElementDescriptor(PsiClass psiClass, String name, boolean isStatic) {
        this.myPsiClass = psiClass;
        this.myName = name;
        this.myStatic = isStatic;
    }

    public boolean isStatic() {
        return this.myStatic;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        PsiElement declaration = this.getDeclaration();
        if (declaration instanceof PsiField) {
            PsiType psiType = ((PsiField)declaration).getType();
            ArrayList<XmlElementDescriptor> descriptors = new ArrayList<XmlElementDescriptor>();
            JavaFxPropertyElementDescriptor.collectDescriptorsByCollection(psiType, declaration.getResolveScope(), descriptors, declaration.getProject());
            for (String name : FxmlConstants.FX_DEFAULT_ELEMENTS) {
                descriptors.add(new JavaFxDefaultPropertyElementDescriptor(name, null));
            }
            if (!descriptors.isEmpty()) {
                return descriptors.toArray(new XmlElementDescriptor[descriptors.size()]);
            }
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    public static void collectDescriptorsByCollection(PsiType psiType, GlobalSearchScope resolveScope, final List<XmlElementDescriptor> descriptors, Project project) {
        PsiType propertyType;
        PsiClass aClass;
        PsiType collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)psiType, (GlobalSearchScope)resolveScope);
        if (collectionItemType != null) {
            PsiClass aClass2 = PsiUtil.resolveClassInType((PsiType)collectionItemType);
            if (aClass2 != null) {
                ClassInheritorsSearch.search((PsiClass)aClass2).forEach((Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass aClass) {
                        descriptors.add(new JavaFxClassBackedElementDescriptor(aClass.getName(), aClass));
                        return true;
                    }
                });
                descriptors.add(new JavaFxClassBackedElementDescriptor(aClass2.getName(), aClass2));
            }
        } else if (InheritanceUtil.isInheritor((PsiType)psiType, (String)"javafx.beans.property.Property") && (aClass = PsiUtil.resolveClassInType((PsiType)(propertyType = JavaFxPsiUtil.getPropertyType(psiType, project)))) != null) {
            descriptors.add(new JavaFxClassBackedElementDescriptor(aClass.getName(), aClass));
        }
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        String name = childTag.getName();
        if (FxmlConstants.FX_DEFAULT_ELEMENTS.contains(name)) {
            return new JavaFxDefaultPropertyElementDescriptor(name, childTag);
        }
        return new JavaFxClassBackedElementDescriptor(name, childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        return XmlAttributeDescriptor.EMPTY;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        PsiType type;
        PsiElement element = this.getDeclaration();
        if (element instanceof PsiField && InheritanceUtil.isInheritor((PsiType)(type = ((PsiField)element).getType()), (String)"java.util.Map")) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        return null;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return -1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        if (this.myPsiClass == null) {
            return null;
        }
        PsiField field = this.myPsiClass.findFieldByName(this.myName, true);
        if (field != null) {
            return field;
        }
        return JavaFxPsiUtil.findPropertySetter(this.myName, this.myPsiClass);
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        if (this.myPsiClass != null && this.myStatic) {
            return StringUtil.getQualifiedName((String)this.myPsiClass.getName(), (String)this.myName);
        }
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

