/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageHelper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.VisibilityUtil;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassBackedElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxDefaultPropertyElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;

public class JavaFxUnresolvedFxIdReferenceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlFile(XmlFile file) {
                if (!JavaFxFileTypeFactory.isFxml((PsiFile)file)) {
                    return;
                }
                super.visitXmlFile(file);
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiClass fieldClass;
                PsiReference reference;
                PsiClass controllerClass;
                XmlAttributeValue valueElement;
                if ("fx:id".equals(attribute.getName()) && (valueElement = attribute.getValueElement()) != null && valueElement.getTextLength() > 0 && (controllerClass = JavaFxPsiUtil.getControllerClass(attribute.getContainingFile())) != null && (reference = valueElement.getReference()) instanceof JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef && ((JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)reference).isUnresolved() && (fieldClass = JavaFxUnresolvedFxIdReferenceInspection.checkContext(((JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)reference).getXmlAttributeValue())) != null) {
                    LocalQuickFix[] localQuickFixArray;
                    String text = reference.getCanonicalText();
                    NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(fieldClass.getLanguage());
                    boolean validName = namesValidator != null && namesValidator.isIdentifier(text, fieldClass.getProject());
                    PsiElement psiElement = reference.getElement();
                    TextRange textRange = reference.getRangeInElement();
                    if (isOnTheFly && validName) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new CreateFieldFromUsageQuickFix(text);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    holder.registerProblem(psiElement, textRange, "Unresolved fx:id reference", localQuickFixArray);
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    protected static PsiClass checkContext(XmlAttributeValue attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        PsiElement parent = attributeValue.getParent();
        if (parent instanceof XmlAttribute) {
            return JavaFxUnresolvedFxIdReferenceInspection.checkClass(((XmlAttribute)parent).getParent());
        }
        return null;
    }

    private static PsiClass checkClass(XmlTag tag) {
        if (tag != null) {
            XmlTag includedRoot;
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (descriptor instanceof JavaFxClassBackedElementDescriptor) {
                PsiElement declaration = descriptor.getDeclaration();
                if (declaration instanceof PsiClass) {
                    return (PsiClass)declaration;
                }
            } else if (descriptor instanceof JavaFxDefaultPropertyElementDescriptor && (includedRoot = JavaFxDefaultPropertyElementDescriptor.getIncludedRoot(tag)) != null && !includedRoot.equals(tag)) {
                return JavaFxUnresolvedFxIdReferenceInspection.checkClass(includedRoot);
            }
        }
        return null;
    }

    private static class CreateFieldFromUsageQuickFix
    implements LocalQuickFix {
        private final String myCanonicalName;

        private CreateFieldFromUsageQuickFix(String canonicalName) {
            this.myCanonicalName = canonicalName;
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message((String)"create.field.from.usage.text", (Object[])new Object[]{this.myCanonicalName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection$CreateFieldFromUsageQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"create.field.from.usage.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection$CreateFieldFromUsageQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection$CreateFieldFromUsageQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxUnresolvedFxIdReferenceInspection$CreateFieldFromUsageQuickFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            XmlAttributeValue attrValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlAttributeValue.class, (boolean)false);
            assert (attrValue != null);
            JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef reference = (JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)attrValue.getReference();
            assert (reference != null);
            PsiClass targetClass = reference.getAClass();
            if (!FileModificationService.getInstance().prepareFileForWrite(targetClass.getContainingFile())) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiField field = factory.createField(reference.getCanonicalText(), (PsiType)PsiType.INT);
            VisibilityUtil.setVisibility((PsiModifierList)field.getModifierList(), (String)"public");
            field = CreateFieldFromUsageHelper.insertField((PsiClass)targetClass, (PsiField)field, (PsiElement)psiElement);
            PsiClassType fieldType = factory.createType(JavaFxUnresolvedFxIdReferenceInspection.checkContext(reference.getXmlAttributeValue()));
            ExpectedTypeInfo[] types = new ExpectedTypeInfo[]{new ExpectedTypeInfoImpl((PsiType)fieldType, 1, (PsiType)fieldType, TailType.NONE, null, ExpectedTypeInfoImpl.NULL)};
            CreateFieldFromUsageFix.createFieldFromUsageTemplate((PsiClass)targetClass, (Project)project, (ExpectedTypeInfo[])types, (PsiField)field, (boolean)false, (PsiElement)psiElement);
        }
    }
}

